#include <list>
#include <algorithm>

// a basic red-green-blue struct
template< class T >
struct rgb 
{
  typedef T   red_type;
  red_type    red;

  typedef T   green_type;
  green_type  green;

  typedef T   blue_type;
  blue_type    blue;
};

// an accessor class for the red field
// accessors get_green and get_blue can be done likewise
template< class T >
class get_red 
{
public:
  typedef T input_type;
  typedef typename T::red_type output_type;
  
  static output_type& get (input_type& v) {
    return v.red;
  }

  static const output_type& get (const input_type& v) {
    return v.red;
  }
};

// A decorator for any iterator :
template< class Decorated, template< class > class Access >
class FieldAccess: public Decorated 
{
public:
  typedef typename Decorated::value_type value_type;
  typedef Access< value_type >		 accessor;
  typedef typename accessor::output_type output_type;
  
  FieldAccess () : Decorated () {}
  FieldAccess (const Decorated& cpy) : Decorated (cpy) {}

  // Overload operator*, use the given accessor to get the proper field.
  output_type& operator* () {
    return accessor::get (Decorated::operator* ());
  }

  const output_type& operator* () const {
    return accessor::get (Decorated::operator* ());
  }
};

int main ()
{
  typedef std::list< rgb< int > > A;
  A input;
  rgb< int > r = {1,2,3};
  input.push_back (r);
  input.push_back (r);
  // ...
  FieldAccess< A::iterator, get_red > 
    start = input.begin (),
    end   = input.end ();
  
  std::fill (start, end, 10);

  for (A::iterator i = input.begin (); i != input.end (); ++i)
    std::cout << i->red << " " << i->green << std::endl;
}
