/*
 *  file generic_iterator.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <assert.h>
#include <iostream>
#include "generic_iterator.hh"




// --------------------------  ConcreteAggregate<T>



template< typename T > inline
ConcreteAggregate<T>::ConcreteAggregate()
{
  for ( unsigned index = 0; index < size(); ++index )
    {
      _value[ index ] = T( index );
    }
}



template< typename T > inline
ConcreteIterator<T>& ConcreteAggregate<T>::CreateIterator()
{
  return *new ConcreteIterator<T>( *this );
}



template< typename T > inline
const T& ConcreteAggregate<T>::value_at( unsigned index ) const
{
  return _value[ index ];
}



template< typename T > inline
T& ConcreteAggregate<T>::value_at( unsigned index )
{
  assert( index < size() ); 
  return _value[ index ];
}



template< typename T > inline
unsigned ConcreteAggregate<T>::size() const
{
  return 10;
}



template< typename T > inline
std::ostream& operator<<( std::ostream& ostr, const ConcreteAggregate<T>& obj )
{
  for ( unsigned index = 0; index < obj.size(); ++index )
    {
      ostr << obj.value_at( index ) << ' ';
    }
  return ostr;
}



// --------------------------  ConcreteIterator<T>



template< typename T > inline
ConcreteIterator<T>::ConcreteIterator( ConcreteAggregate<T>& aggregate ) :
  _aggregate( aggregate )
{
  _index = _aggregate.size();
}



template< typename T > inline
void ConcreteIterator<T>::First()
{
  _index = 0;
}



template< typename T > inline
void ConcreteIterator<T>::Next()
{
  ++_index;
}



template< typename T > inline
bool ConcreteIterator<T>::IsDone() const
{
  return _index >= _aggregate.size();
}



template< typename T > inline
T& ConcreteIterator<T>::CurrentItem()
{
  return _aggregate.value_at( _index );
}



template< typename A >
void add( A& input, typename A::value_type value )
{
   typename A::iterator_type& iter = input.CreateIterator();
   for ( iter.First(); ! iter.IsDone(); iter.Next() )
      iter.CurrentItem() += value;
}



// --------------------------  main



int main()
{
  ConcreteAggregate<int> aggregate;
  std::cout << aggregate << std::endl;
  add( aggregate, 1 );
  std::cout << aggregate << std::endl;  
}
