with Ada.Integer_Text_Io;

with Matrix33;
with Matrix33.Inst;
with Matrix33_Sum;

procedure Matrix_Test is
   package Mymat is new Matrix33 (Integer);
   Mat1, Mat2, Mat3, Bar: Mymat.Object;
   use Mymat;
begin
   Set_Val (Mat1, 1, 1, 1);
   Set_Val (Mat2, 3, 1, 1);
   Set_Val (Mat3, -2, 1, 1);
   declare
      package Inst1 is new Mymat.Inst (Mat1);
      package Inst2 is new Mymat.Inst (Mat2);
      package Inst3 is new Mymat.Inst (Mat3);
      package Plus12 is
         new Matrix33_Sum (Integer, Inst1.Closure, Inst2.Closure);
      package Plus123 is
         new Matrix33_Sum (Integer, Plus12.Closure, Inst3.Closure);
      procedure Assign is new Assign_From_Closure (Plus123.Closure);
   begin
      Assign (Bar);
      Ada.Integer_Text_Io.Put (Bar (1,1));
   end;
end Matrix_Test;
