/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.util.Collection;
import jdd.bdd.BDD;
import jdd.bdd.Permutation;
import jdd.bdd.debug.BDDDebugFrame;
import jdd.bdd.debug.BDDDebuger;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class ProfiledBDD2
extends BDD {
    private long p_and = 0L;
    private long p_or = 0L;
    private long p_xor = 0L;
    private long p_biimp = 0L;
    private long p_imp = 0L;
    private long p_not = 0L;
    private long p_nand;
    private long p_nor;
    private long p_replace = 0L;
    private long p_exists = 0L;
    private long p_forall = 0L;
    private long p_relprod = 0L;
    private long p_support = 0L;
    private long p_restrict = 0L;
    private long p_simplify = 0L;
    private long p_ite = 0L;
    private long p_satcount = 0L;
    private long p_permutation = 0L;
    private long t_and = 0L;
    private long t_or = 0L;
    private long t_xor = 0L;
    private long t_biimp = 0L;
    private long t_imp = 0L;
    private long t_not = 0L;
    private long t_nand;
    private long t_nor;
    private long t_replace = 0L;
    private long t_exists = 0L;
    private long t_forall = 0L;
    private long t_relprod = 0L;
    private long t_support = 0L;
    private long t_restrict = 0L;
    private long t_simplify = 0L;
    private long t_ite = 0L;
    private long t_satcount = 0L;
    private long t_permutation = 0L;

    public ProfiledBDD2(int n) {
        this(n, 1000);
    }

    public ProfiledBDD2(int n, int n2) {
        super(n, n2);
        if (Options.profile_cache) {
            new BDDDebugFrame(this);
        }
    }

    @Override
    public Collection addDebugger(BDDDebuger bDDDebuger) {
        Collection collection = super.addDebugger(bDDDebuger);
        collection.add(this.quant_cache);
        collection.add(this.ite_cache);
        collection.add(this.not_cache);
        collection.add(this.op_cache);
        collection.add(this.replace_cache);
        collection.add(this.sat_cache);
        return collection;
    }

    @Override
    public int and(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_and;
        int n3 = super.and(n, n2);
        this.t_and += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int or(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_or;
        int n3 = super.or(n, n2);
        this.t_or += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int xor(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_xor;
        int n3 = super.xor(n, n2);
        this.t_xor += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int biimp(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_biimp;
        int n3 = super.biimp(n, n2);
        this.t_biimp += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int imp(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_imp;
        int n3 = super.imp(n, n2);
        this.t_imp += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int nor(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_nor;
        int n3 = super.nor(n, n2);
        this.t_nor += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int nand(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_nand;
        int n3 = super.nand(n, n2);
        this.t_nand += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int not(int n) {
        long l = System.currentTimeMillis();
        ++this.p_not;
        int n2 = super.not(n);
        this.t_not += System.currentTimeMillis() - l;
        return n2;
    }

    @Override
    public int replace(int n, Permutation permutation) {
        long l = System.currentTimeMillis();
        ++this.p_replace;
        int n2 = super.replace(n, permutation);
        this.t_replace += System.currentTimeMillis() - l;
        return n2;
    }

    @Override
    public int exists(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_exists;
        int n3 = super.exists(n, n2);
        this.t_exists += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int forall(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_forall;
        int n3 = super.forall(n, n2);
        this.t_forall += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int relProd(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        ++this.p_relprod;
        int n4 = super.relProd(n, n2, n3);
        this.t_relprod += System.currentTimeMillis() - l;
        return n4;
    }

    @Override
    public int support(int n) {
        long l = System.currentTimeMillis();
        ++this.p_support;
        int n2 = super.support(n);
        this.t_support += System.currentTimeMillis() - l;
        return n2;
    }

    @Override
    public int restrict(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_restrict;
        int n3 = super.restrict(n, n2);
        this.t_restrict += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int simplify(int n, int n2) {
        long l = System.currentTimeMillis();
        ++this.p_simplify;
        int n3 = super.simplify(n, n2);
        this.t_simplify += System.currentTimeMillis() - l;
        return n3;
    }

    @Override
    public int ite(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        ++this.p_ite;
        int n4 = super.ite(n, n2, n3);
        this.t_ite += System.currentTimeMillis() - l;
        return n4;
    }

    @Override
    public double satCount(int n) {
        long l = System.currentTimeMillis();
        ++this.p_satcount;
        double d = super.satCount(n);
        this.t_satcount += System.currentTimeMillis() - l;
        return d;
    }

    @Override
    public Permutation createPermutation(int[] nArray, int[] nArray2) {
        long l = System.currentTimeMillis();
        ++this.p_permutation;
        Permutation permutation = super.createPermutation(nArray, nArray2);
        this.t_permutation += System.currentTimeMillis() - l;
        return permutation;
    }

    public void report(String string, long l, long l2) {
        if (l > 0L) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("calls to " + string);
            while (stringBuffer.length() < 28) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(" : " + l + " times");
            while (stringBuffer.length() < 48) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(" " + l2 + " [ms]");
            JDDConsole.out.println(stringBuffer.toString());
        }
    }

    @Override
    public void showStats() {
        this.report("AND", this.p_and, this.t_and);
        this.report("OR", this.p_or, this.t_or);
        this.report("NAND", this.p_nand, this.t_nand);
        this.report("NOR", this.p_nor, this.t_nor);
        this.report("XOR", this.p_xor, this.t_xor);
        this.report("BI-IMP", this.p_biimp, this.t_biimp);
        this.report("IMP", this.p_imp, this.t_imp);
        this.report("NOT", this.p_not, this.t_not);
        this.report("ITE", this.p_ite, this.t_ite);
        this.report("REPLACE", this.p_replace, this.t_replace);
        this.report("EXISTS", this.p_exists, this.t_exists);
        this.report("FORALL", this.p_forall, this.t_forall);
        this.report("REL-PROD", this.p_relprod, this.t_relprod);
        this.report("SUPPORT", this.p_support, this.t_support);
        this.report("RESTRICT", this.p_restrict, this.t_restrict);
        this.report("SIMPLIFY", this.p_simplify, this.t_simplify);
        this.report("SAT-COUNT", this.p_satcount, this.t_satcount);
        this.report("CREATE-PERMUTATION", this.p_permutation, this.t_permutation);
        super.showStats();
    }
}

