/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.output;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BooleanExpressions;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.output.HoaPrinter;
import owl.collections.ValuationSet;

final class HoaConsumerExtended<S> {
    private static final Logger log = Logger.getLogger(HoaConsumerExtended.class.getName());
    private final int alphabetSize;
    private final HOAConsumer consumer;
    private final EnumSet<HoaPrinter.HoaOption> options;
    private final Object2IntMap<S> stateNumbers;
    @Nullable
    private S currentState = null;
    final Automaton.HybridVisitor<S> visitor = new Visitor();

    HoaConsumerExtended(HOAConsumer consumer, List<String> aliases, OmegaAcceptance acceptance, Set<S> initialStates, EnumSet<HoaPrinter.HoaOption> options, boolean isDeterministic, String name) {
        this.consumer = consumer;
        this.options = EnumSet.copyOf(options);
        this.stateNumbers = new Object2IntOpenHashMap();
        this.alphabetSize = aliases.size();
        try {
            consumer.notifyHeaderStart("v1");
            consumer.setTool(HoaConsumerExtended.tool(), HoaConsumerExtended.version());
            if (options.contains((Object)HoaPrinter.HoaOption.ANNOTATIONS)) {
                consumer.setName(name);
            }
            for (S state : initialStates) {
                consumer.addStartStates(List.of(Integer.valueOf(this.getStateId(state))));
            }
            String accName = acceptance.name();
            if (accName != null) {
                consumer.provideAcceptanceName(accName, acceptance.nameExtra());
            }
            consumer.setAcceptanceCondition(acceptance.acceptanceSets(), acceptance.booleanExpression());
            if (!initialStates.isEmpty() && isDeterministic) {
                consumer.addProperties(List.of("deterministic"));
            }
            consumer.addProperties(List.of("trans-acc", "trans-label"));
            consumer.setAPs(aliases);
            consumer.notifyBodyStart();
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    private static String tool() {
        String title = HoaConsumerExtended.class.getPackage().getImplementationTitle();
        return title == null ? "owl" : title;
    }

    private static String version() {
        String version = HoaConsumerExtended.class.getPackage().getImplementationVersion();
        return version == null ? "development" : version;
    }

    void addEdge(ValuationSet label, S end) {
        if (label.isEmpty()) {
            return;
        }
        this.addEdgeBackend(label.toExpression(), end, (IntList)IntLists.EMPTY_LIST);
    }

    private void addEdgeBackend(BitSet label, S end, IntList accSets) {
        ArrayList conjuncts = new ArrayList(this.alphabetSize);
        for (int i = 0; i < this.alphabetSize; ++i) {
            BooleanExpression atom = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)i));
            if (label.get(i)) {
                conjuncts.add(atom);
                continue;
            }
            conjuncts.add(atom.not());
        }
        this.addEdgeBackend(BooleanExpressions.createConjunction(conjuncts), end, accSets);
    }

    private void addEdgeBackend(BooleanExpression<AtomLabel> label, S end, IntList accSets) {
        try {
            this.consumer.addEdgeWithLabel(this.getStateId(this.currentState), label, List.of(Integer.valueOf(this.getStateId(end))), (List)(accSets.isEmpty() ? null : accSets));
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    void addEpsilonEdge(S successor) {
        log.log(Level.FINER, "HOA currently does not support epsilon-transitions. ({0} -> {1})", new Object[]{this.currentState, successor});
        try {
            this.consumer.addEdgeWithLabel(this.getStateId(this.currentState), null, List.of(Integer.valueOf(this.getStateId(successor))), null);
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    private int getStateId(@Nullable S state) {
        Preconditions.checkState((state != null ? 1 : 0) != 0);
        return this.stateNumbers.computeIntIfAbsent(state, k -> this.stateNumbers.size());
    }

    void done() {
        try {
            this.consumer.notifyEnd();
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    private class Visitor
    implements Automaton.HybridVisitor<S> {
        private Visitor() {
        }

        @Override
        public void enter(S state) {
            HoaConsumerExtended.this.currentState = state;
            String label = HoaConsumerExtended.this.options.contains((Object)HoaPrinter.HoaOption.ANNOTATIONS) ? state.toString() : null;
            try {
                HoaConsumerExtended.this.consumer.addState(HoaConsumerExtended.this.getStateId(state), label, null, null);
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        @Override
        public void exit(S state) {
            Preconditions.checkState((boolean)state.equals(HoaConsumerExtended.this.currentState));
            try {
                HoaConsumerExtended.this.consumer.notifyEndOfState(HoaConsumerExtended.this.getStateId(HoaConsumerExtended.this.currentState));
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        @Override
        public void visitEdge(Edge<S> edge, BitSet valuation) {
            IntArrayList accSets = new IntArrayList();
            edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntArrayList)accSets).add(arg_0));
            HoaConsumerExtended.this.addEdgeBackend(valuation, edge.successor(), (IntList)accSets);
        }

        @Override
        public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
            Object end = edge.successor();
            if (valuationSet.isEmpty()) {
                return;
            }
            IntArrayList acceptanceSets = new IntArrayList();
            edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntArrayList)acceptanceSets).add(arg_0));
            if (HoaConsumerExtended.this.options.contains((Object)HoaPrinter.HoaOption.SIMPLE_TRANSITION_LABELS)) {
                valuationSet.forEach(bitSet -> HoaConsumerExtended.this.addEdgeBackend(bitSet, end, (IntList)acceptanceSets));
            } else {
                HoaConsumerExtended.this.addEdgeBackend((BooleanExpression<AtomLabel>)valuationSet.toExpression(), end, (IntList)acceptanceSets);
            }
        }
    }
}

