/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import owl.ltl.AbstractFormula;
import owl.ltl.Formula;

public abstract class BinaryModalOperator
extends AbstractFormula {
    public final Formula left;
    public final Formula right;

    BinaryModalOperator(Formula leftOperand, Formula rightOperand) {
        this.left = leftOperand;
        this.right = rightOperand;
    }

    @Override
    public boolean allMatch(Predicate<Formula> predicate) {
        return predicate.test(this) && this.left.allMatch(predicate) && this.right.allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<Formula> predicate) {
        return predicate.test(this) || this.left.anyMatch(predicate) || this.right.anyMatch(predicate);
    }

    @Override
    protected final int hashCodeOnce() {
        return Objects.hash(Character.valueOf(this.getOperator()), this.left, this.right);
    }

    @Override
    protected final boolean equals2(AbstractFormula o) {
        assert (this.getClass() == o.getClass());
        BinaryModalOperator that = (BinaryModalOperator)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public abstract char getOperator();

    @Override
    public Formula temporalStep(BitSet valuation) {
        return this;
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return this.unfold();
    }

    public String toString() {
        return String.format("(%s%s%s)", this.left, Character.valueOf(this.getOperator()), this.right);
    }
}

