/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import owl.ltl.AbstractFormula;
import owl.ltl.Formula;

public abstract class UnaryModalOperator
extends AbstractFormula {
    public final Formula operand;

    UnaryModalOperator(Formula operand) {
        this.operand = operand;
    }

    @Override
    public boolean allMatch(Predicate<Formula> predicate) {
        return predicate.test(this) && this.operand.allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<Formula> predicate) {
        return predicate.test(this) || this.operand.anyMatch(predicate);
    }

    @Override
    protected int hashCodeOnce() {
        return Objects.hash(this.getOperator(), this.operand);
    }

    @Override
    protected boolean equals2(AbstractFormula o) {
        assert (this.getClass() == o.getClass());
        UnaryModalOperator that = (UnaryModalOperator)o;
        return Objects.equals(this.operand, that.operand);
    }

    public Formula getOperand() {
        return this.operand;
    }

    public abstract String getOperator();

    @Override
    public Formula temporalStep(BitSet valuation) {
        return this;
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return this.unfold();
    }

    public String toString() {
        return this.getOperator() + this.operand;
    }
}

