/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2ldba.AbstractLTL2LDBAModule;
import owl.translations.ltl2ldba.LTL2LDBAFunction;

public final class LTL2LDBAModule
extends AbstractLTL2LDBAModule {
    public static final LTL2LDBAModule INSTANCE = new LTL2LDBAModule();

    private LTL2LDBAModule() {
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        EnumSet<LTL2LDBAFunction.Configuration> configuration = LTL2LDBAModule.configuration(commandLine);
        if (commandLine.hasOption(LTL2LDBAModule.guessF().getOpt())) {
            return environment -> Transformers.instanceFromFunction(LabelledFormula.class, LTL2LDBAFunction.createDegeneralizedBreakpointFreeLDBABuilder(environment, configuration));
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, LTL2LDBAFunction.createDegeneralizedBreakpointLDBABuilder(environment, configuration));
    }

    @Override
    public String getKey() {
        return "ltl2ldba";
    }

    @Override
    public String getDescription() {
        return "Translates LTL to limit-deterministic B\u00fcchi automata";
    }
}

