/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpointfree;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2ldba.AbstractAcceptingComponentBuilder;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;
import owl.translations.ltl2ldba.breakpointfree.GeneralizedBreakpointFreeState;

public final class GeneralizedAcceptingComponentBuilder
extends AbstractAcceptingComponentBuilder<GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance, FGObligations> {
    @Nonnegative
    private int acceptanceSets = 1;

    public GeneralizedAcceptingComponentBuilder(Factories factories, Set<LTL2LDBAFunction.Configuration> optimisations) {
        super(optimisations, factories);
    }

    @Override
    public MutableAutomaton<GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance> build() {
        return MutableAutomatonFactory.create(GeneralizedBuchiAcceptance.of(this.acceptanceSets), this.factories.vsFactory, this.anchors, this::getSuccessor, this::getSensitiveAlphabet);
    }

    @Override
    protected GeneralizedBreakpointFreeState createState(EquivalenceClass remainder, FGObligations obligations) {
        EquivalenceClass safety = remainder.and(obligations.safety);
        EquivalenceClass[] liveness = new EquivalenceClass[obligations.liveness.size()];
        for (int i = 0; i < liveness.length; ++i) {
            liveness[i] = this.factory.getInitial(obligations.liveness.get(i), new EquivalenceClass[0]);
        }
        if (liveness.length > this.acceptanceSets) {
            this.acceptanceSets = liveness.length;
        }
        return new GeneralizedBreakpointFreeState(this.factory.getInitial(safety, liveness), liveness, obligations);
    }

    private BitSet getSensitiveAlphabet(GeneralizedBreakpointFreeState state) {
        BitSet sensitiveAlphabet = this.factory.getSensitiveAlphabet(state.safety);
        for (EquivalenceClass clazz : state.liveness) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(this.factory.getInitial(clazz, new EquivalenceClass[0])));
        }
        return sensitiveAlphabet;
    }

    @Nullable
    private Edge<GeneralizedBreakpointFreeState> getSuccessor(GeneralizedBreakpointFreeState state, BitSet valuation) {
        EquivalenceClass[] livenessSuccessor = new EquivalenceClass[state.liveness.length];
        BitSet bs = new BitSet();
        bs.set(state.liveness.length, this.acceptanceSets);
        for (int i = 0; i < state.liveness.length; ++i) {
            livenessSuccessor[i] = this.factory.getSuccessor(state.liveness[i], valuation, new EquivalenceClass[0]);
            if (!livenessSuccessor[i].isTrue()) continue;
            bs.set(i);
            livenessSuccessor[i] = this.factory.getInitial(state.obligations.liveness.get(i), new EquivalenceClass[0]);
        }
        EquivalenceClass safetySuccessor = this.factory.getSuccessor(state.safety, valuation, livenessSuccessor);
        if (safetySuccessor.isFalse()) {
            return null;
        }
        assert (Arrays.stream(livenessSuccessor).noneMatch(EquivalenceClass::isFalse)) : "Liveness properties cannot be false.";
        return Edge.of(new GeneralizedBreakpointFreeState(safetySuccessor, livenessSuccessor, state.obligations), bs);
    }
}

