/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public class LatexPrintVisitor
implements Visitor<String> {
    private final List<String> alphabet;

    public LatexPrintVisitor(List<String> alphabet) {
        this.alphabet = List.copyOf(alphabet);
    }

    @Override
    public String visit(BooleanConstant booleanConstant) {
        return booleanConstant.value ? " \\true " : " \\false ";
    }

    @Override
    public String visit(Conjunction conjunction) {
        return this.visit(conjunction, " \\wedge ");
    }

    @Override
    public String visit(Disjunction disjunction) {
        return this.visit(disjunction, " \\vee ");
    }

    @Override
    public String visit(FOperator fOperator) {
        return this.visit((UnaryModalOperator)fOperator);
    }

    @Override
    public String visit(GOperator gOperator) {
        return this.visit((UnaryModalOperator)gOperator);
    }

    @Override
    public String visit(Literal literal) {
        String name = this.alphabet.get(literal.getAtom());
        return literal.isNegated() ? "\\overline{" + name + "}" : name;
    }

    @Override
    public String visit(MOperator mOperator) {
        return this.visit((BinaryModalOperator)mOperator);
    }

    @Override
    public String visit(ROperator rOperator) {
        return this.visit((BinaryModalOperator)rOperator);
    }

    @Override
    public String visit(UOperator uOperator) {
        return this.visit((BinaryModalOperator)uOperator);
    }

    @Override
    public String visit(WOperator wOperator) {
        return this.visit((BinaryModalOperator)wOperator);
    }

    @Override
    public String visit(XOperator xOperator) {
        return this.visit((UnaryModalOperator)xOperator);
    }

    private String visit(UnaryModalOperator operator) {
        if (operator.operand instanceof UnaryModalOperator || operator.operand instanceof Literal) {
            return "\\" + operator.operatorSymbol() + " " + operator.operand.accept(this);
        }
        return "\\" + operator.operatorSymbol() + " (" + operator.operand.accept(this) + ")";
    }

    private String visit(BinaryModalOperator operator) {
        return Stream.of(operator.left, operator.right).map(x -> {
            if (x instanceof Literal) {
                return x.accept(this);
            }
            return "(" + x.accept(this) + ")";
        }).collect(Collectors.joining(" \\" + operator.operatorSymbol() + " "));
    }

    private String visit(PropositionalFormula propositionalFormula, String latexString) {
        return propositionalFormula.children.stream().sorted(Comparator.naturalOrder()).map(x -> {
            if (x instanceof Formula.LogicalOperator && !(x instanceof BooleanConstant)) {
                return "(" + x.accept(this) + ")";
            }
            return x.accept(this);
        }).collect(Collectors.joining(latexString));
    }
}

