/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.List;
import org.immutables.value.Value;
import owl.ltl.EquivalenceClass;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.RabinizerStateTuple;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class RabinizerState {
    public abstract EquivalenceClass masterState();

    public abstract List<MonitorState> monitorStates();

    static RabinizerState of(EquivalenceClass masterState, MonitorState[] monitorStates) {
        return RabinizerStateTuple.create(masterState, List.of(monitorStates));
    }

    static RabinizerState of(EquivalenceClass masterState, List<MonitorState> monitorStates) {
        return RabinizerStateTuple.create(masterState, monitorStates);
    }

    static RabinizerState empty(EquivalenceClass masterState) {
        return RabinizerStateTuple.create(masterState, List.of());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(50 * (1 + this.monitorStates().size()));
        builder.append("<<").append(this.masterState());
        for (MonitorState monitorState : this.monitorStates()) {
            builder.append("::").append(monitorState);
        }
        builder.append(">>");
        return builder.toString();
    }
}

