/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2dpa;

import java.util.List;
import java.util.Set;
import org.immutables.value.Value;
import owl.collections.Collections3;
import owl.translations.nba2dpa.RankingStateTuple;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class RankingState<S> {
    abstract Set<S> initialComponentStates();

    abstract List<S> acceptingComponentStates();

    static <S> RankingState<S> of(Set<S> initialComponentStates, List<S> acceptingComponentStates) {
        assert (Collections3.isDistinct(acceptingComponentStates)) : "The ranking is not distinct: " + acceptingComponentStates;
        return RankingStateTuple.create(initialComponentStates, acceptingComponentStates);
    }

    public String toString() {
        return String.format("|%s :: %s|", this.initialComponentStates(), this.acceptingComponentStates());
    }
}

