/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.SyntacticFragments;
import owl.translations.SafetyCoreDetector;
import owl.translations.ltl2dpa.AsymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;

final class AsymmetricDPAConstruction {
    private AsymmetricDPAConstruction() {
    }

    static Automaton<AsymmetricRankingState, ParityAcceptance> of(AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba) {
        Builder builder = new Builder(ldba);
        return AutomatonFactory.create(builder.ldba.factory(), builder.initialState, builder.acceptance, builder::edge);
    }

    static final class Builder {
        final ParityAcceptance acceptance;
        final AsymmetricRankingState initialState;
        final EquivalenceClassFactory factory;
        final List<Set<EquivalenceClass>> initialComponentSccs;
        final AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba;

        private Builder(AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba) {
            this.ldba = ldba;
            this.initialComponentSccs = SccDecomposition.computeSccs(ldba.initialComponent());
            this.acceptance = new ParityAcceptance(2 * Math.max(1, ldba.acceptingComponent().size() + 1), ParityAcceptance.Parity.MIN_ODD);
            EquivalenceClass ldbaInitialState = ldba.initialComponent().onlyInitialState();
            this.factory = ldbaInitialState.factory();
            this.initialState = this.edge(ldbaInitialState, List.of(), -1, null).successor();
        }

        Edge<AsymmetricRankingState> edge(EquivalenceClass successor, List<AsymmetricProductState> previousRanking, int previousSafetyProgress, @Nullable BitSet valuation) {
            int safetyProgress;
            if (SafetyCoreDetector.safetyCoreExists(successor)) {
                return Edge.of(AsymmetricRankingState.of(successor), 1);
            }
            HashSet<AsymmetricEvaluatedFixpoints> availableFixpoints = new HashSet<AsymmetricEvaluatedFixpoints>();
            List partitionedFixpoints = List.of(new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap());
            for (AsymmetricProductState jumpTarget : this.ldba.stateAnnotation().apply(successor)) {
                AsymmetricEvaluatedFixpoints fixpoints = jumpTarget.evaluatedFixpoints;
                boolean changed = availableFixpoints.add(fixpoints);
                assert (changed) : "Detected two jumps to the same component." + this.ldba.stateAnnotation().apply(successor);
                if (fixpoints.isSafety()) {
                    if (SyntacticFragments.isSafety(jumpTarget.language().modalOperators())) {
                        ((NavigableMap)partitionedFixpoints.get(3)).put(fixpoints, jumpTarget);
                        continue;
                    }
                    ((NavigableMap)partitionedFixpoints.get(2)).put(fixpoints, jumpTarget);
                    continue;
                }
                if (fixpoints.isLiveness()) {
                    ((NavigableMap)partitionedFixpoints.get(0)).put(fixpoints, jumpTarget);
                    continue;
                }
                ((NavigableMap)partitionedFixpoints.get(1)).put(fixpoints, jumpTarget);
            }
            ArrayList<AsymmetricProductState> ranking = new ArrayList<AsymmetricProductState>(previousRanking.size());
            int rankingColor = 2 * previousRanking.size();
            EquivalenceClass rankingLanguage = this.factory.getFalse();
            Iterator<AsymmetricProductState> iterator = previousRanking.iterator();
            while (iterator.hasNext()) {
                Edge<AsymmetricProductState> rankingEdge;
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                AsymmetricProductState rankingState = iterator.next();
                Edge<AsymmetricProductState> edge = rankingEdge = this.ldba.acceptingComponent().states().contains(rankingState) ? this.ldba.acceptingComponent().edge(rankingState, valuation) : null;
                if (rankingEdge == null) {
                    rankingColor = Math.min(2 * ranking.size(), rankingColor);
                    continue;
                }
                AsymmetricProductState rankingSuccessor = rankingEdge.successor();
                AsymmetricEvaluatedFixpoints fixpoints = Objects.requireNonNull(rankingSuccessor.evaluatedFixpoints);
                EquivalenceClass successorLanguage = rankingSuccessor.language();
                if (!availableFixpoints.contains(fixpoints) || successorLanguage.implies(rankingLanguage)) {
                    rankingColor = Math.min(2 * ranking.size(), rankingColor);
                    continue;
                }
                if (rankingEdge.inSet(0)) {
                    rankingColor = Math.min(2 * ranking.size() + 1, rankingColor);
                    rankingLanguage = rankingLanguage.or(fixpoints.language());
                } else {
                    rankingLanguage = rankingLanguage.or(successorLanguage);
                }
                ranking.add(rankingSuccessor);
                if (iterator.hasNext() || !((NavigableMap)partitionedFixpoints.get(3)).containsKey(rankingSuccessor.evaluatedFixpoints) || this.ldba.annotation().headSet(fixpoints).size() != previousSafetyProgress) continue;
                rankingLanguage = this.factory.getTrue();
            }
            if (rankingLanguage.isTrue()) {
                safetyProgress = ranking.isEmpty() ? -1 : previousSafetyProgress;
            } else {
                Iterable<Object> orderedSafetyStates;
                for (AsymmetricProductState jumpTarget : Iterables.concat(((NavigableMap)partitionedFixpoints.get(0)).values(), ((NavigableMap)partitionedFixpoints.get(1)).values(), ((NavigableMap)partitionedFixpoints.get(2)).values())) {
                    EquivalenceClass jumpTargetLanguage = jumpTarget.language();
                    if (jumpTargetLanguage.implies(rankingLanguage)) continue;
                    ranking.add(jumpTarget);
                    rankingLanguage = rankingLanguage.or(jumpTargetLanguage);
                }
                NavigableMap availableSafetyFixpoints = partitionedFixpoints.get(3);
                if (previousSafetyProgress >= 0) {
                    AsymmetricEvaluatedFixpoints previousSafetyFixpoints = (AsymmetricEvaluatedFixpoints)Iterables.get((Iterable)this.ldba.annotation(), (int)previousSafetyProgress);
                    orderedSafetyStates = Iterables.concat(availableSafetyFixpoints.tailMap(previousSafetyFixpoints, false).values(), availableSafetyFixpoints.headMap(previousSafetyFixpoints, true).values());
                } else {
                    orderedSafetyStates = availableSafetyFixpoints.values();
                }
                safetyProgress = -1;
                for (AsymmetricProductState safetyState : orderedSafetyStates) {
                    if (safetyState.language().implies(rankingLanguage)) continue;
                    ranking.add(safetyState);
                    safetyProgress = this.ldba.annotation().headSet(safetyState.evaluatedFixpoints).size();
                    break;
                }
            }
            assert (rankingColor < this.acceptance.acceptanceSets());
            return Edge.of(AsymmetricRankingState.of(successor, ranking, safetyProgress), rankingColor);
        }

        @Nullable
        Edge<AsymmetricRankingState> edge(AsymmetricRankingState macroState, BitSet valuation) {
            EquivalenceClass successor = this.ldba.initialComponent().successor(macroState.state(), valuation);
            if (successor == null) {
                return null;
            }
            if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(macroState.state()) && !x.contains(successor))) {
                return this.edge(successor, List.of(), -1, valuation).withoutAcceptance();
            }
            return this.edge(successor, macroState.ranking(), macroState.safetyIndex(), valuation);
        }
    }
}

