/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.run.Pipeline;
import owl.run.RunUtil;
import owl.run.modules.OwlModuleRegistry;
import owl.run.parser.OwlParser;

public final class ServerCli {
    private static final Logger logger = Logger.getLogger(ServerCli.class.getName());

    private ServerCli() {
    }

    public static void main(String ... args) throws UnknownHostException {
        int port;
        Options options = new Options().addOption(new Option(null, "port", true, "Port to listen on (default: 5050)")).addOption(new Option(null, "bind", true, "Address to listen on (default: localhost)")).addOption(RunUtil.getDefaultAnnotationOption());
        OwlParser parseResult = OwlParser.parse(args, (CommandLineParser)new DefaultParser(), options, OwlModuleRegistry.DEFAULT_REGISTRY);
        if (parseResult == null) {
            System.exit(1);
            return;
        }
        Pipeline pipeline = parseResult.pipeline;
        InetAddress address = Strings.isNullOrEmpty((String)parseResult.globalSettings.getOptionValue("bind")) ? InetAddress.getLoopbackAddress() : InetAddress.getByName(parseResult.globalSettings.getOptionValue("bind"));
        if (Strings.isNullOrEmpty((String)parseResult.globalSettings.getOptionValue("port"))) {
            port = 5050;
        } else {
            try {
                port = Integer.parseInt(parseResult.globalSettings.getOptionValue("port"));
            }
            catch (NumberFormatException e) {
                throw RunUtil.failWithMessage("Invalid value for port", e);
            }
        }
        logger.log(Level.INFO, "Starting server on {0}:{1}", new Object[]{address, port});
        ExecutorService connectionExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        try (ServerSocketChannel socket = ServerSocketChannel.open().bind(new InetSocketAddress(address, port));){
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                logger.log(Level.INFO, "Received shutdown signal, closing socket {0}", socket);
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e, () -> "Error while closing server socket " + socket);
                }
            }));
            while (socket.isOpen()) {
                try {
                    SocketChannel connection = socket.accept();
                    logger.log(Level.FINE, "New connection from {0}", socket);
                    connectionExecutor.submit(() -> {
                        try (SocketChannel socketChannel = connection;){
                            pipeline.run(connection, connection);
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "Error while handling connection", t);
                            Throwables.throwIfUnchecked((Throwable)t);
                        }
                    });
                }
                catch (IOException e) {
                    if (socket.isOpen()) {
                        logger.log(Level.SEVERE, "Unexpected IO exception while waiting for connections", e);
                        continue;
                    }
                    logger.log(Level.FINE, "Server socket {0} closed, awaiting termination", socket);
                }
            }
            logger.log(Level.FINER, "Waiting for remaining tasks to finish");
            connectionExecutor.shutdown();
            while (!connectionExecutor.isTerminated()) {
                try {
                    connectionExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.log(Level.FINE, "Finished all remaining tasks");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unexpected IO exception while waiting for connections", e);
            connectionExecutor.shutdownNow();
        }
    }

    static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger factoryNumber = new AtomicInteger(1);
        private final ThreadGroup group = Thread.currentThread().getThreadGroup();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final int number = factoryNumber.getAndIncrement();

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = String.format("owl-worker-%d-%d", this.number, this.threadNumber.getAndIncrement());
            Thread t = new Thread(this.group, r, name);
            t.setDaemon(true);
            return t;
        }
    }
}

