/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.common.collect.ImmutableBiMap;
import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.translations.nbadet.SubsumedStatesMap;
import owl.util.BitSetUtil;

public final class NbaAdjMat<S> {
    private final Automaton<S, BuchiAcceptance> aut;
    private final ImmutableBiMap<S, Integer> stateMap;
    private final BitSet states;
    @Nullable
    private final BitSet aSinks;
    @Nullable
    private final SubsumedStatesMap usedLangIncl;
    private final ArrayList<ArrayList<Pair<BitSet, BitSet>>> mat;

    public Automaton<S, BuchiAcceptance> original() {
        return this.aut;
    }

    public ImmutableBiMap<S, Integer> stateMap() {
        return this.stateMap;
    }

    public BitSet states() {
        return this.states;
    }

    public NbaAdjMat(Automaton<S, BuchiAcceptance> automaton, ImmutableBiMap<S, Integer> sMap, Set<S> aSinks, SubsumedStatesMap extIncl) {
        this.aut = automaton;
        this.stateMap = sMap;
        this.states = BitSetUtil.all(this.stateMap);
        this.aSinks = aSinks.isEmpty() ? null : BitSetUtil.fromSet(aSinks, this.stateMap);
        this.usedLangIncl = extIncl.isEmpty() ? null : extIncl;
        this.mat = new ArrayList();
        IntStream.range(0, 1 << this.aut.factory().atomicPropositions().size()).forEach(i -> {
            BitSet sym = BitSet.valueOf(new long[]{i});
            ArrayList symmat = new ArrayList();
            IntStream.range(0, this.aut.states().size()).forEach(st -> {
                BitSet allSucc = new BitSet(sMap.size());
                BitSet accSucc = new BitSet(sMap.size());
                this.aut.edges(sMap.inverse().get((Object)st), sym).forEach(e -> {
                    allSucc.set((Integer)sMap.get(e.successor()));
                    if (this.aut.acceptance().isAcceptingEdge((Edge<?>)e)) {
                        accSucc.set((Integer)sMap.get(e.successor()));
                    }
                });
                symmat.add(Pair.of(allSucc, accSucc));
            });
            this.mat.add(symmat);
        });
    }

    public Pair<BitSet, BitSet> succ(int st, int sym) {
        return this.mat.get(sym).get(st);
    }

    public Pair<BitSet, BitSet> powerSucc(BitSet state, BitSet valuation) {
        int sym = BitSetUtil.toInt(valuation);
        BitSet allSuccs = new BitSet();
        BitSet accSuccs = new BitSet();
        state.stream().forEach(st -> {
            Pair<BitSet, BitSet> sucs = this.succ(st, sym);
            allSuccs.or(sucs.fst());
            accSuccs.or(sucs.snd());
        });
        if (this.aSinks != null && !BitSets.isDisjoint((BitSet)allSuccs, (BitSet)this.aSinks)) {
            return Pair.of(this.aSinks, this.aSinks);
        }
        if (this.usedLangIncl != null) {
            BitSet maskedAllSuccs = (BitSet)allSuccs.clone();
            allSuccs.stream().forEach(i -> this.usedLangIncl.removeSubsumed(i, maskedAllSuccs));
            return Pair.of(maskedAllSuccs, BitSetUtil.intersection(accSuccs, maskedAllSuccs));
        }
        return Pair.of(allSuccs, accSuccs);
    }

    private String toString(int st, int sym) {
        Function<Integer, Object> stmap = arg_0 -> ((ImmutableBiMap)this.stateMap.inverse()).get(arg_0);
        Pair<BitSet, BitSet> succs = this.succ(st, sym);
        Set<Object> aSuccs = BitSetUtil.toSet(succs.snd(), stmap);
        Set<Object> nSuccs = BitSetUtil.toSet(BitSetUtil.without(succs.fst(), succs.snd()), stmap);
        String symStr = this.aut.factory().of(BitSetUtil.fromInt(sym)).toExpression().toString();
        if (aSuccs.isEmpty() && nSuccs.isEmpty()) {
            return "";
        }
        return this.stateMap.inverse().get((Object)st) + "\t-[" + symStr + "]>\t" + aSuccs + ", " + nSuccs + "\n";
    }

    public String toString() {
        return IntStream.range(0, this.aut.states().size()).mapToObj(st -> IntStream.range(0, this.mat.size()).mapToObj(sym -> this.toString(st, sym)).reduce((a, b) -> a + b).orElse("")).reduce((a, b) -> a + b).orElse("");
    }
}

