/*
 * Decompiled with CFR 0.152.
 */
package owl.game.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.Game;
import owl.game.GameViews;
import owl.game.algorithms.ParityGameSolver;
import owl.run.modules.OwlModule;

public final class ZielonkaGameSolver
implements ParityGameSolver {
    public static final OwlModule<OwlModule.Transformer> ZIELONKA_SOLVER = OwlModule.of("zielonka", "Solves a game using Zielonka's algorithm", (commandLine, environment) -> object -> {
        Preconditions.checkArgument((boolean)(object instanceof Game), (String)"Expected type %s, got type %s", Game.class, object.getClass());
        Game x = (Game)object;
        ParityGameSolver.WinningRegions winning = ZielonkaGameSolver.recursiveZielonka(x);
        return winning.player2.contains(x.onlyInitialState()) ? "The specification is REALISABLE" : "The specification is UNREALISABLE";
    });

    private static <S> ParityGameSolver.WinningRegions<S> recursiveZielonka(Game<S, ParityAcceptance> game) {
        Game.Owner ourHorse;
        Set states = game.states();
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        AtomicInteger minimalColour = new AtomicInteger(acceptance.acceptanceSets());
        for (Object state : states) {
            game.edges(state).forEach(edge -> minimalColour.getAndUpdate(c -> Math.min(c, edge.smallestAcceptanceSet())));
        }
        int theMinimalColour = minimalColour.get();
        Game.Owner owner = ourHorse = acceptance.isAccepting(theMinimalColour) ? Game.Owner.PLAYER_2 : Game.Owner.PLAYER_1;
        if (theMinimalColour == acceptance.acceptanceSets()) {
            return new ParityGameSolver.WinningRegions(states, ourHorse);
        }
        Predicate<Edge> hasMinCol = y -> y.smallestAcceptanceSet() == theMinimalColour;
        Set winningStates = Sets.filter(states, x -> {
            if (game.owner(x) != Game.Owner.PLAYER_2) {
                return false;
            }
            if (Game.Owner.PLAYER_2 == ourHorse) {
                return game.edges(x).stream().anyMatch(hasMinCol);
            }
            return game.edges(x).stream().allMatch(hasMinCol);
        });
        assert (winningStates.stream().allMatch(x -> game.owner(x) == Game.Owner.PLAYER_2));
        Sets.SetView losingSet = Sets.difference(states, game.getAttractorFixpoint(winningStates, ourHorse));
        Game<Object, ParityAcceptance> subGame = GameViews.filter(game, ((Set)losingSet)::contains, hasMinCol.negate());
        ParityGameSolver.WinningRegions<Object> subWinning = ZielonkaGameSolver.recursiveZielonka(subGame);
        if (subWinning.winningRegion(ourHorse).containsAll(subGame.states())) {
            return new ParityGameSolver.WinningRegions(states, ourHorse);
        }
        Set<Object> opponentAttractor = game.getAttractorFixpoint(subWinning.winningRegion(ourHorse.opponent()), ourHorse.opponent());
        Sets.SetView difference = Sets.difference(states, opponentAttractor);
        ParityGameSolver.WinningRegions<Object> newSubWinning = ZielonkaGameSolver.recursiveZielonka(GameViews.filter(game, ((Set)difference)::contains));
        newSubWinning.addAll(opponentAttractor, ourHorse.opponent());
        return newSubWinning;
    }

    public static <S> boolean zielonkaRealizability(Game<S, ParityAcceptance> game) {
        return ZielonkaGameSolver.recursiveZielonka(GameViews.replaceInitialStates(game, game.states())).player2.contains(game.onlyInitialState());
    }

    @Override
    public <S> boolean realizable(Game<S, ParityAcceptance> game) {
        return ZielonkaGameSolver.zielonkaRealizability(game);
    }

    @Override
    public <S> ParityGameSolver.WinningRegions<S> solve(Game<S, ParityAcceptance> game) {
        return ZielonkaGameSolver.recursiveZielonka(game);
    }
}

