/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class ROperator
extends Formula.BinaryTemporalOperator {
    public ROperator(Formula leftOperand, Formula rightOperand) {
        super(ROperator.class, leftOperand, rightOperand);
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (rightOperand instanceof BooleanConstant || rightOperand instanceof GOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return GOperator.of(rightOperand);
        }
        if (leftOperand instanceof ROperator && rightOperand.equals(((ROperator)leftOperand).rightOperand())) {
            return leftOperand;
        }
        return new ROperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "R";
    }

    @Override
    public Formula nnf() {
        return ROperator.of(this.leftOperand().nnf(), this.rightOperand().nnf());
    }

    @Override
    public Formula not() {
        return UOperator.of(this.leftOperand().not(), this.rightOperand().not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.rightOperand().unfold(), Disjunction.of(this.leftOperand().unfold(), (Formula)this));
    }
}

