/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.util;

import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.collections.Collections3;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;

public final class FormulaIsomorphism {
    private FormulaIsomorphism() {
    }

    @Nullable
    public static int[] compute(Formula formula1, Formula formula2) {
        BitSet atoms1 = formula1.atomicPropositions(true);
        BitSet atoms2 = formula2.atomicPropositions(true);
        if (atoms1.cardinality() != atoms2.cardinality()) {
            return null;
        }
        if (formula1.height() != formula2.height()) {
            return null;
        }
        ValidationVisitor preValidationVisitor = new ValidationVisitor(null);
        if (!formula1.accept(preValidationVisitor, formula2).booleanValue()) {
            return null;
        }
        List atomsList1 = atoms1.stream().boxed().collect(Collectors.toList());
        List atomsList2 = atoms2.stream().boxed().collect(Collectors.toList());
        int[] mapping = new int[atoms1.length()];
        Arrays.fill(mapping, -1);
        ValidationVisitor validationVisitor = new ValidationVisitor(mapping);
        for (List atomsList2Perm : Collections2.permutations(atomsList2)) {
            Collections3.forEachPair(atomsList1, atomsList2Perm, (x, y) -> {
                mapping[x.intValue()] = y;
            });
            if (!formula1.accept(validationVisitor, formula2).booleanValue()) continue;
            return mapping;
        }
        return null;
    }

    private static final class ValidationVisitor
    implements BinaryVisitor<Formula, Boolean> {
        @Nullable
        private final int[] mapping;

        private ValidationVisitor(@Nullable int[] mapping) {
            this.mapping = mapping;
        }

        @Override
        public Boolean visit(Biconditional biconditional, Formula formula) {
            if (!(formula instanceof Biconditional)) {
                return Boolean.FALSE;
            }
            return biconditional.leftOperand().accept(this, ((Biconditional)formula).leftOperand()) != false && biconditional.rightOperand().accept(this, ((Biconditional)formula).rightOperand()) != false;
        }

        @Override
        public Boolean visit(BooleanConstant booleanConstant, Formula formula) {
            return booleanConstant.equals(formula);
        }

        @Override
        public Boolean visit(Conjunction conjunction, Formula formula) {
            return this.visitNaryPropositionalOperator(conjunction, formula);
        }

        @Override
        public Boolean visit(Disjunction disjunction, Formula formula) {
            return this.visitNaryPropositionalOperator(disjunction, formula);
        }

        @Override
        public Boolean visit(FOperator fOperator, Formula formula) {
            return this.visitTemporal(fOperator, formula);
        }

        @Override
        public Boolean visit(GOperator gOperator, Formula formula) {
            return this.visitTemporal(gOperator, formula);
        }

        @Override
        public Boolean visit(Literal literal, Formula formula) {
            if (!(formula instanceof Literal)) {
                return Boolean.FALSE;
            }
            Literal otherLiteral = (Literal)formula;
            if (literal.isNegated() ^ otherLiteral.isNegated()) {
                return Boolean.FALSE;
            }
            return this.mapping == null ? Boolean.TRUE : this.mapping[literal.getAtom()] == otherLiteral.getAtom();
        }

        @Override
        public Boolean visit(MOperator mOperator, Formula formula) {
            return this.visitTemporal(mOperator, formula);
        }

        @Override
        public Boolean visit(UOperator uOperator, Formula formula) {
            return this.visitTemporal(uOperator, formula);
        }

        @Override
        public Boolean visit(ROperator rOperator, Formula formula) {
            return this.visitTemporal(rOperator, formula);
        }

        @Override
        public Boolean visit(WOperator wOperator, Formula formula) {
            return this.visitTemporal(wOperator, formula);
        }

        @Override
        public Boolean visit(XOperator xOperator, Formula formula) {
            return this.visitTemporal(xOperator, formula);
        }

        private Boolean visitTemporal(Formula.TemporalOperator formula1, Formula formula2) {
            if (!formula1.getClass().isInstance(formula2)) {
                return Boolean.FALSE;
            }
            if (formula1.height() != formula2.height()) {
                return Boolean.FALSE;
            }
            List children1 = formula1.operands;
            List<Formula> children2 = formula2.operands;
            assert (children1.size() == children2.size());
            for (int i = 0; i < children1.size(); ++i) {
                if (((Formula)children1.get(i)).accept(this, children2.get(i)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private Boolean visitNaryPropositionalOperator(Formula formula1, Formula formula2) {
            if (!formula1.getClass().isInstance(formula2)) {
                return Boolean.FALSE;
            }
            if (formula1.height() != formula2.height()) {
                return Boolean.FALSE;
            }
            List<Formula> children1 = formula1.operands;
            List<Formula> children2 = formula2.operands;
            if (children1.size() != children2.size()) {
                return Boolean.FALSE;
            }
            for (List children2Permutation : Collections2.permutations(children2)) {
                int i;
                for (i = 0; i < children1.size() && children1.get(i).accept(this, (Formula)children2Permutation.get(i)).booleanValue(); ++i) {
                }
                if (i != children1.size()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

