/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.Pair;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateAccepting;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateRejecting;
import owl.translations.canonical.RoundRobinState;
import owl.translations.canonical.Util;

public final class DeterministicConstructions {
    private DeterministicConstructions() {
    }

    @AutoValue
    public static abstract class BreakpointStateRejecting {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass rejecting();

        public static BreakpointStateRejecting of(EquivalenceClass all, EquivalenceClass rejecting) {
            assert (all.implies(rejecting));
            return new AutoValue_DeterministicConstructions_BreakpointStateRejecting(all, rejecting);
        }
    }

    public static final class SafetyCoSafety
    extends Base<BreakpointStateRejecting, BuchiAcceptance> {
        private SafetyCoSafety(Factories factories, BreakpointStateRejecting initialState) {
            super(factories, initialState, BuchiAcceptance.INSTANCE);
        }

        public static SafetyCoSafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((SyntacticFragments.isSafetyCoSafety(formula) && !SyntacticFragments.isCoSafety(formula) && !SyntacticFragments.isSafety(formula) && (!(formula instanceof Conjunction) || !formula.operands.stream().allMatch(SyntacticFragments::isGfCoSafety)) ? 1 : 0) != 0);
            EquivalenceClass formulaClass = SafetyCoSafety.initialStateInternal(factories.eqFactory.of(formula));
            BreakpointStateRejecting initialState = BreakpointStateRejecting.of(formulaClass, SafetyCoSafety.rejecting(formulaClass));
            return new SafetyCoSafety(factories, initialState);
        }

        @Override
        @Nullable
        public Edge<BreakpointStateRejecting> edge(BreakpointStateRejecting state, BitSet valuation) {
            return SafetyCoSafety.edge(SafetyCoSafety.successorInternal(state.all(), valuation), SafetyCoSafety.successorInternal(state.rejecting(), valuation), SafetyCoSafety.successorInternal(SafetyCoSafety.rejecting(state.all()), valuation));
        }

        @Override
        public ValuationTree<Edge<BreakpointStateRejecting>> edgeTree(BreakpointStateRejecting state) {
            return ValuationTrees.cartesianProduct(SafetyCoSafety.successorTreeInternal(state.all()), SafetyCoSafety.successorTreeInternal(state.rejecting()), SafetyCoSafety.successorTreeInternal(SafetyCoSafety.rejecting(state.all())), SafetyCoSafety::edge);
        }

        @Nullable
        private static Edge<BreakpointStateRejecting> edge(EquivalenceClass all, EquivalenceClass rejecting, EquivalenceClass nextRejecting) {
            assert (all.implies(rejecting) && all.implies(nextRejecting));
            if (all.isFalse() || rejecting.isFalse() || nextRejecting.isFalse()) {
                return null;
            }
            if (SyntacticFragments.isSafety(all)) {
                return Edge.of(BreakpointStateRejecting.of(all, all), 0);
            }
            assert (!all.isTrue());
            if (SyntacticFragments.isCoSafety(all)) {
                return Edge.of(BreakpointStateRejecting.of(all, all));
            }
            if (rejecting.isTrue()) {
                if (nextRejecting.isTrue()) {
                    return Edge.of(BreakpointStateRejecting.of(all, SafetyCoSafety.rejecting(all)), 0);
                }
                return Edge.of(BreakpointStateRejecting.of(all, nextRejecting), 0);
            }
            return Edge.of(BreakpointStateRejecting.of(all, rejecting));
        }

        private static EquivalenceClass rejecting(EquivalenceClass all) {
            Set protectedXOperators;
            EquivalenceClass rejecting = all.substitute(x -> SyntacticFragments.isCoSafety(x) ? x : BooleanConstant.TRUE);
            assert (SyntacticFragments.isCoSafety(rejecting));
            EquivalenceClass xRemovedRejecting = rejecting;
            while (!(rejecting = xRemovedRejecting).equals(xRemovedRejecting = rejecting.substitute(arg_0 -> SafetyCoSafety.lambda$rejecting$2(protectedXOperators = rejecting.temporalOperators().stream().flatMap(x -> x instanceof XOperator ? Stream.empty() : x.subformulas(XOperator.class).stream()).collect(Collectors.toSet()), arg_0)))) {
            }
            return rejecting.unfold();
        }

        private static /* synthetic */ Formula lambda$rejecting$2(Set protectedXOperators, Formula.TemporalOperator x) {
            return x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.TRUE : x;
        }
    }

    @AutoValue
    public static abstract class BreakpointStateAccepting {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass accepting();

        static BreakpointStateAccepting of(EquivalenceClass all, EquivalenceClass accepting) {
            assert (accepting.implies(all));
            return new AutoValue_DeterministicConstructions_BreakpointStateAccepting(all, accepting);
        }
    }

    public static final class CoSafetySafety
    extends Base<BreakpointStateAccepting, CoBuchiAcceptance> {
        private CoSafetySafety(Factories factories, BreakpointStateAccepting initialState) {
            super(factories, initialState, CoBuchiAcceptance.INSTANCE);
        }

        public static CoSafetySafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((SyntacticFragments.isCoSafetySafety(formula) && !SyntacticFragments.isCoSafety(formula) && !SyntacticFragments.isSafety(formula) && (!(formula instanceof Disjunction) || !formula.operands.stream().allMatch(SyntacticFragments::isFgSafety)) ? 1 : 0) != 0);
            EquivalenceClass formulaClass = CoSafetySafety.initialStateInternal(factories.eqFactory.of(formula));
            BreakpointStateAccepting initialState = BreakpointStateAccepting.of(formulaClass, CoSafetySafety.accepting(formulaClass));
            return new CoSafetySafety(factories, initialState);
        }

        @Override
        @Nullable
        public Edge<BreakpointStateAccepting> edge(BreakpointStateAccepting state, BitSet valuation) {
            return CoSafetySafety.edge(CoSafetySafety.successorInternal(state.all(), valuation), CoSafetySafety.successorInternal(state.accepting(), valuation), CoSafetySafety.successorInternal(CoSafetySafety.accepting(state.all()), valuation));
        }

        @Override
        public ValuationTree<Edge<BreakpointStateAccepting>> edgeTree(BreakpointStateAccepting state) {
            return ValuationTrees.cartesianProduct(CoSafetySafety.successorTreeInternal(state.all()), CoSafetySafety.successorTreeInternal(state.accepting()), CoSafetySafety.successorTreeInternal(CoSafetySafety.accepting(state.all())), CoSafetySafety::edge);
        }

        @Nullable
        private static Edge<BreakpointStateAccepting> edge(EquivalenceClass all, EquivalenceClass accepting, EquivalenceClass nextAccepting) {
            assert (accepting.implies(all) && nextAccepting.implies(all));
            if (all.isFalse()) {
                return null;
            }
            if (SyntacticFragments.isSafety(all)) {
                return Edge.of(BreakpointStateAccepting.of(all, all));
            }
            assert (!(all.isTrue() || accepting.isTrue() || nextAccepting.isTrue()));
            if (SyntacticFragments.isCoSafety(all)) {
                return Edge.of(BreakpointStateAccepting.of(all, all), 0);
            }
            if (accepting.isFalse()) {
                if (nextAccepting.isFalse()) {
                    return Edge.of(BreakpointStateAccepting.of(all, CoSafetySafety.accepting(all)), 0);
                }
                return Edge.of(BreakpointStateAccepting.of(all, nextAccepting), 0);
            }
            return Edge.of(BreakpointStateAccepting.of(all, accepting));
        }

        private static EquivalenceClass accepting(EquivalenceClass all) {
            Set protectedXOperators;
            EquivalenceClass accepting = all.substitute(x -> SyntacticFragments.isSafety(x) ? x : BooleanConstant.FALSE);
            assert (SyntacticFragments.isSafety(accepting));
            EquivalenceClass xRemovedAccepting = accepting;
            while (!(accepting = xRemovedAccepting).equals(xRemovedAccepting = accepting.substitute(arg_0 -> CoSafetySafety.lambda$accepting$2(protectedXOperators = accepting.temporalOperators().stream().flatMap(x -> x instanceof XOperator ? Stream.empty() : x.subformulas(XOperator.class).stream()).collect(Collectors.toSet()), arg_0)))) {
            }
            return accepting.unfold();
        }

        private static /* synthetic */ Formula lambda$accepting$2(Set protectedXOperators, Formula.TemporalOperator x) {
            return x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.FALSE : x;
        }
    }

    public static class GfCoSafety
    extends Base<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> {
        private final RoundRobinState<EquivalenceClass> fallbackInitialState;
        private final ValuationTree<Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> initialStatesSuccessorTree;

        private GfCoSafety(Factories factories, RoundRobinState<EquivalenceClass> initialState, RoundRobinState<EquivalenceClass> fallbackInitialState, ValuationTree<Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> tree, GeneralizedBuchiAcceptance acceptance) {
            super(factories, initialState, acceptance);
            this.fallbackInitialState = fallbackInitialState;
            this.initialStatesSuccessorTree = tree;
        }

        /*
         * WARNING - void declaration
         */
        public static GfCoSafety of(Factories factories, Set<? extends Formula> formulas, boolean generalized) {
            Object initialState;
            void var7_9;
            Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
            EquivalenceClassFactory factory = factories.eqFactory;
            ArrayList<FOperator> automata = new ArrayList<FOperator>();
            ArrayList<Formula> singletonAutomata = new ArrayList<Formula>();
            for (Formula formula : formulas) {
                Preconditions.checkArgument((boolean)SyntacticFragments.isGfCoSafety(formula), (Object)formula);
                Formula unwrapped = Util.unwrap(Util.unwrap(formula));
                if (generalized && SyntacticFragment.SINGLE_STEP.contains(unwrapped)) {
                    singletonAutomata.add(unwrapped);
                    continue;
                }
                automata.add(new FOperator(unwrapped));
            }
            singletonAutomata.sort(Comparator.naturalOrder());
            if (automata.isEmpty()) {
                automata.add(new FOperator((Formula)singletonAutomata.remove(0)));
            } else {
                automata.sort(Comparator.naturalOrder());
            }
            ValuationTree initialStatesSuccessorTreeTemp = ValuationTree.of(Set.of(List.of()));
            boolean bl = false;
            while (var7_9 < automata.size()) {
                void j = var7_9++;
                initialState = GfCoSafety.initialStateInternal(factory.of((Formula)automata.get((int)j)));
                ValuationTree initialStateSuccessorTree = GfCoSafety.successorTreeInternal((EquivalenceClass)initialState, arg_0 -> GfCoSafety.lambda$of$0((int)j, arg_0));
                initialStatesSuccessorTreeTemp = ValuationTrees.cartesianProduct(initialStatesSuccessorTreeTemp, initialStateSuccessorTree, Collections3::add);
            }
            ValuationTree<Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> valuationTree = ValuationTrees.cartesianProduct(initialStatesSuccessorTreeTemp, Util.singleStepTree(singletonAutomata), (x, y) -> Pair.of(List.copyOf(x), y));
            RoundRobinState<EquivalenceClass> fallbackInitialState = RoundRobinState.of(0, GfCoSafety.initialStateInternal(factory.of((Formula)automata.get(0))));
            initialState = GfCoSafety.buildEdge(0, GfCoSafety.successorInternal(fallbackInitialState.state(), new BitSet()), valuationTree.get(new BitSet()).iterator().next(), fallbackInitialState).successor();
            return new GfCoSafety(factories, (RoundRobinState<EquivalenceClass>)initialState, fallbackInitialState, valuationTree, GeneralizedBuchiAcceptance.of(singletonAutomata.size() + 1));
        }

        private static Edge<RoundRobinState<EquivalenceClass>> buildEdge(int index, EquivalenceClass successor, Pair<List<RoundRobinState<EquivalenceClass>>, BitSet> initialStateSuccessors, RoundRobinState<EquivalenceClass> fallbackInitialState) {
            if (!successor.isTrue()) {
                return Edge.of(RoundRobinState.of(index, successor), initialStateSuccessors.snd());
            }
            int size = initialStateSuccessors.fst().size();
            List<RoundRobinState<EquivalenceClass>> latterSuccessors = initialStateSuccessors.fst().subList(index + 1, size);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : latterSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, initialStateSuccessors.snd());
            }
            BitSet acceptance = (BitSet)initialStateSuccessors.snd().clone();
            acceptance.set(0);
            List<RoundRobinState<EquivalenceClass>> earlierSuccessors = initialStateSuccessors.fst().subList(0, index + 1);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : earlierSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, acceptance);
            }
            return Edge.of(fallbackInitialState, acceptance);
        }

        @Override
        @Nonnull
        public final Edge<RoundRobinState<EquivalenceClass>> edge(RoundRobinState<EquivalenceClass> state, BitSet valuation) {
            EquivalenceClass successor = GfCoSafety.successorInternal(state.state(), valuation);
            Set<Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> initialStateSuccessors = this.initialStatesSuccessorTree.get(valuation);
            return GfCoSafety.buildEdge(state.index(), successor, initialStateSuccessors.iterator().next(), this.fallbackInitialState);
        }

        @Override
        public final ValuationTree<Edge<RoundRobinState<EquivalenceClass>>> edgeTree(RoundRobinState<EquivalenceClass> state) {
            ValuationTree<EquivalenceClass> successorTree = GfCoSafety.successorTreeInternal(state.state());
            return ValuationTrees.cartesianProduct(successorTree, this.initialStatesSuccessorTree, (x, y) -> GfCoSafety.buildEdge(state.index(), x, y, this.fallbackInitialState));
        }

        @Override
        public final boolean is(Automaton.Property property) {
            if (property == Automaton.Property.COMPLETE) {
                return true;
            }
            return super.is(property);
        }
    }

    public static final class Tracking
    extends Base<EquivalenceClass, AllAcceptance> {
        public Tracking(Factories factories) {
            super(factories, factories.eqFactory.of(BooleanConstant.TRUE), AllAcceptance.INSTANCE);
        }

        public EquivalenceClass asInitialState(Formula state) {
            return this.factory.of(state).unfold();
        }

        @Override
        public Edge<EquivalenceClass> edge(EquivalenceClass clazz, BitSet valuation) {
            return Edge.of(clazz.temporalStep(valuation).unfold());
        }

        public ValuationTree<EquivalenceClass> successorTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree(x -> Set.of(x.unfold()));
        }

        @Override
        public ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree(x -> Set.of(Edge.of(x.unfold())));
        }
    }

    public static final class Safety
    extends Looping<AllAcceptance> {
        private Safety(Factories factories, Formula formula) {
            super(factories, formula, AllAcceptance.INSTANCE);
        }

        public static Safety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafety(formula), (Object)formula);
            return new Safety(factories, formula);
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            return successor.isFalse() ? null : Edge.of(successor);
        }

        public EquivalenceClass onlyInitialStateWithRemainder(EquivalenceClass remainder) {
            return ((EquivalenceClass)this.onlyInitialState()).and(Safety.initialStateInternal(remainder));
        }
    }

    public static final class CoSafety
    extends Looping<BuchiAcceptance> {
        private CoSafety(Factories factories, Formula formula) {
            super(factories, formula, BuchiAcceptance.INSTANCE);
        }

        public static CoSafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafety(formula), (Object)formula);
            return new CoSafety(factories, formula);
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            if (successor.isFalse()) {
                return null;
            }
            return successor.isTrue() ? Edge.of(successor, 0) : Edge.of(successor);
        }
    }

    private static abstract class Looping<A extends OmegaAcceptance>
    extends Base<EquivalenceClass, A> {
        private final Function<EquivalenceClass, Set<Edge<EquivalenceClass>>> edgeMapper = x -> Collections3.ofNullable(this.buildEdge(x.unfold()));

        private Looping(Factories factories, Formula formula, A acceptance) {
            super(factories, Looping.initialStateInternal(factories.eqFactory.of(formula)), acceptance);
        }

        @Override
        @Nullable
        public final Edge<EquivalenceClass> edge(EquivalenceClass clazz, BitSet valuation) {
            return this.buildEdge(Looping.successorInternal(clazz, valuation));
        }

        @Override
        public final ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree(this.edgeMapper);
        }

        @Nullable
        protected abstract Edge<EquivalenceClass> buildEdge(EquivalenceClass var1);
    }

    static abstract class Base<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton.NonDeterministicEdgeTreeAutomaton<S, A> {
        final EquivalenceClassFactory factory;

        Base(Factories factories, S initialState, A acceptance) {
            super(factories.vsFactory, Set.of(initialState), acceptance);
            this.factory = factories.eqFactory;
        }

        @Override
        @Nullable
        public abstract Edge<S> edge(S var1, BitSet var2);

        @Override
        public final Set<Edge<S>> edges(S state, BitSet valuation) {
            return Collections3.ofNullable(this.edge(state, valuation));
        }

        @Override
        public abstract ValuationTree<Edge<S>> edgeTree(S var1);

        @Override
        public boolean is(Automaton.Property property) {
            if (property == Automaton.Property.DETERMINISTIC || property == Automaton.Property.SEMI_DETERMINISTIC || property == Automaton.Property.LIMIT_DETERMINISTIC) {
                return true;
            }
            return super.is(property);
        }

        static EquivalenceClass initialStateInternal(EquivalenceClass clazz) {
            return clazz.unfold();
        }

        static EquivalenceClass successorInternal(EquivalenceClass clazz, BitSet valuation) {
            return clazz.temporalStep(valuation).unfold();
        }

        static ValuationTree<EquivalenceClass> successorTreeInternal(EquivalenceClass clazz) {
            return clazz.temporalStepTree(preSuccessor -> Set.of(preSuccessor.unfold()));
        }

        static <T> ValuationTree<T> successorTreeInternal(EquivalenceClass clazz, Function<EquivalenceClass, Set<T>> edgeFunction) {
            return clazz.temporalStepTree(x -> (Set)edgeFunction.apply(x.unfold()));
        }
    }
}

