/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.ArrayDeque;
import java.util.HashSet;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.bdd.BddSet;

public final class MutableAutomatonUtil {
    private MutableAutomatonUtil() {
    }

    public static <S, A extends EmersonLeiAcceptance> MutableAutomaton<S, A> asMutable(Automaton<S, A> automaton) {
        if (automaton instanceof MutableAutomaton) {
            return (MutableAutomaton)automaton;
        }
        return HashMapAutomaton.copyOf(automaton);
    }

    public static <S> void copyInto(Automaton<S, ?> source, MutableAutomaton<? super S, ?> target) {
        ArrayDeque workList = new ArrayDeque(source.initialStates());
        HashSet visited = new HashSet(workList);
        while (!workList.isEmpty()) {
            Object state = workList.remove();
            target.addState(state);
            source.edgeMap(state).forEach((x, y) -> {
                target.addEdge(state, (BddSet)y, x);
                if (visited.add(x.successor())) {
                    workList.add(x.successor());
                }
            });
        }
    }
}

