/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import java.util.BitSet;
import java.util.List;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_SimulationStates_LookaheadSimulationState;
import owl.automaton.algorithm.simulations.AutoValue_SimulationStates_MultipebbleSimulationState;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.algorithm.simulations.Transition;
import owl.collections.BitSet2;
import owl.game.Game;

public class SimulationStates {
    private SimulationStates() {
    }

    @AutoValue
    public static abstract class MultipebbleSimulationState<S>
    extends SimulationType.SimulationState {
        public abstract Pebble<S> odd();

        public abstract MultiPebble<S> even();

        public abstract int valuation();

        static <S> MultipebbleSimulationState<S> of(Pebble<S> odd, MultiPebble<S> even) {
            return new AutoValue_SimulationStates_MultipebbleSimulationState<S>(Game.Owner.PLAYER_1, odd, even, -1);
        }

        static <S> MultipebbleSimulationState<S> of(Pebble<S> odd, MultiPebble<S> even, BitSet val) {
            return new AutoValue_SimulationStates_MultipebbleSimulationState<S>(Game.Owner.PLAYER_2, odd, even, BitSet2.toInt(val));
        }

        public String toString() {
            return (this.owner().isOdd() ? "O: " : "E: ") + this.odd().toString() + "|" + this.even().toString() + " " + this.valuation();
        }
    }

    @AutoValue
    public static abstract class LookaheadSimulationState<S>
    extends SimulationType.SimulationState {
        public abstract S odd();

        public abstract S even();

        public abstract List<Transition<S>> moves();

        static <S> LookaheadSimulationState<S> of(S odd, S even) {
            return new AutoValue_SimulationStates_LookaheadSimulationState<S>(Game.Owner.PLAYER_1, odd, even, List.of());
        }

        static <S> LookaheadSimulationState<S> of(S odd, S even, List<Transition<S>> buf) {
            return new AutoValue_SimulationStates_LookaheadSimulationState<S>(Game.Owner.PLAYER_2, odd, even, buf);
        }

        public String toString() {
            return (this.owner().isOdd() ? "O: " : "E: ") + this.odd().toString() + "|" + this.even().toString() + (this.moves().isEmpty() ? "" : this.moves().toString());
        }

        public boolean isValid(Automaton<S, BuchiAcceptance> aut) {
            boolean out = true;
            S current = this.odd();
            for (Transition<S> move : this.moves()) {
                out &= move.isValid(current, aut);
                current = move.target();
            }
            return out;
        }

        public boolean flag() {
            return this.moves().stream().anyMatch(Transition::flag);
        }
    }
}

