/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.logic.propositional.PropositionalFormula;

public abstract class MtBdd<E> {
    private MtBdd() {
    }

    public static <E> MtBdd<E> of() {
        return Leaf.EMPTY;
    }

    public static <E> MtBdd<E> of(Collection<? extends E> value) {
        switch (value.size()) {
            case 0: {
                return MtBdd.of();
            }
            case 1: {
                return new Leaf<E>(Set.of(value.iterator().next()));
            }
        }
        return new Leaf<E>(Set.copyOf(value));
    }

    public static <E> MtBdd<E> of(int variable, MtBdd<E> trueChild, MtBdd<E> falseChild) {
        if (trueChild.equals(falseChild)) {
            return trueChild;
        }
        return new Node<E>(variable, trueChild, falseChild);
    }

    public static <E> MtBdd<E> of(Map<E, PropositionalFormula<Integer>> map) {
        ArrayList keys = new ArrayList(map.size());
        ArrayList<PropositionalFormula<Integer>> values = new ArrayList<PropositionalFormula<Integer>>(map.size());
        map.forEach((key, value) -> {
            keys.add(key);
            values.add((PropositionalFormula<Integer>)value);
        });
        return MtBdd.of(keys, values, new HashMap<ArrayList<PropositionalFormula<Integer>>, MtBdd<E>>());
    }

    private static <E> MtBdd<E> of(ArrayList<E> keys, ArrayList<PropositionalFormula<Integer>> values, HashMap<ArrayList<PropositionalFormula<Integer>>, MtBdd<E>> cache) {
        MtBdd<E> tree = cache.get(values);
        if (tree != null) {
            return tree;
        }
        int nextVariable = Integer.MAX_VALUE;
        for (PropositionalFormula<Integer> formula : values) {
            Optional<Integer> variable = formula.smallestVariable();
            if (!variable.isPresent()) continue;
            Preconditions.checkState((0 <= (nextVariable = Math.min(nextVariable, variable.get())) && nextVariable < Integer.MAX_VALUE ? 1 : 0) != 0);
        }
        if (nextVariable == Integer.MAX_VALUE) {
            ArrayList<E> trueKeys = new ArrayList<E>();
            int s = keys.size();
            for (int i = 0; i < s; ++i) {
                PropositionalFormula<Integer> value = values.get(i);
                assert (value.isTrue() || value.isFalse());
                if (!value.isTrue()) continue;
                trueKeys.add(keys.get(i));
            }
            return MtBdd.of(trueKeys);
        }
        int smallestVariable = nextVariable;
        ArrayList<PropositionalFormula<Integer>> trueValues = new ArrayList<PropositionalFormula<Integer>>(values.size());
        ArrayList<PropositionalFormula<Integer>> falseValues = new ArrayList<PropositionalFormula<Integer>>(values.size());
        int s = values.size();
        for (int i = 0; i < s; ++i) {
            PropositionalFormula<Integer> value = values.get(i);
            if (value.containsVariable(smallestVariable)) {
                trueValues.add(value.substitute(v -> v == smallestVariable ? PropositionalFormula.trueConstant() : PropositionalFormula.Variable.of(v)));
                falseValues.add(value.substitute(v -> v == smallestVariable ? PropositionalFormula.falseConstant() : PropositionalFormula.Variable.of(v)));
                continue;
            }
            trueValues.add(value);
            falseValues.add(value);
        }
        tree = MtBdd.of(smallestVariable, MtBdd.of(keys, trueValues, cache), MtBdd.of(keys, falseValues, cache));
        cache.put(values, tree);
        return tree;
    }

    public abstract Set<E> get(BitSet var1);

    public Set<E> flatValues() {
        HashSet values = new HashSet();
        this.memoizedFlatValues(values, Collections.newSetFromMap(new IdentityHashMap()));
        return values;
    }

    public final Set<Set<E>> values() {
        HashSet<Set<E>> values = new HashSet<Set<E>>();
        this.memoizedValues(values, Collections.newSetFromMap(new IdentityHashMap()));
        return values;
    }

    public final Map<E, BddSet> inverse(BddSetFactory factory) {
        return this.inverse(factory, IntUnaryOperator.identity());
    }

    public final Map<E, BddSet> inverse(BddSetFactory factory, IntUnaryOperator mapping) {
        return this.memoizedInverse(factory, new HashMap<MtBdd<E>, Map<E, BddSet>>(), mapping);
    }

    public final <T> MtBdd<T> map(Function<? super Set<E>, ? extends Set<? extends T>> mapper) {
        return this.memoizedMap(mapper, new HashMap<MtBdd<E>, MtBdd<T>>());
    }

    protected abstract <T> MtBdd<T> memoizedMap(Function<? super Set<E>, ? extends Set<? extends T>> var1, Map<MtBdd<E>, MtBdd<T>> var2);

    protected abstract Map<E, BddSet> memoizedInverse(BddSetFactory var1, Map<MtBdd<E>, Map<E, BddSet>> var2, IntUnaryOperator var3);

    protected abstract void memoizedFlatValues(Set<E> var1, Set<MtBdd<E>> var2);

    protected abstract void memoizedValues(Set<Set<E>> var1, Set<MtBdd<E>> var2);

    public static final class Node<E>
    extends MtBdd<E> {
        public final int variable;
        public final MtBdd<E> trueChild;
        public final MtBdd<E> falseChild;
        private final int hashCode;

        private Node(int variable, MtBdd<E> trueChild, MtBdd<E> falseChild) {
            if (variable < 0) {
                throw new IndexOutOfBoundsException(variable);
            }
            if (trueChild instanceof Node) {
                Objects.checkIndex(variable, ((Node)trueChild).variable);
            }
            if (falseChild instanceof Node) {
                Objects.checkIndex(variable, ((Node)falseChild).variable);
            }
            this.variable = variable;
            this.trueChild = trueChild;
            this.falseChild = falseChild;
            int result = 1;
            result = 31 * result + variable;
            result = 31 * result + trueChild.hashCode();
            this.hashCode = result = 31 * result + falseChild.hashCode();
        }

        @Override
        public Set<E> get(BitSet valuation) {
            return valuation.get(this.variable) ? this.trueChild.get(valuation) : this.falseChild.get(valuation);
        }

        @Override
        protected void memoizedFlatValues(Set<E> values, Set<MtBdd<E>> seenNodes) {
            if (!seenNodes.add(this)) {
                return;
            }
            this.trueChild.memoizedFlatValues(values, seenNodes);
            this.falseChild.memoizedFlatValues(values, seenNodes);
        }

        @Override
        protected void memoizedValues(Set<Set<E>> values, Set<MtBdd<E>> seenNodes) {
            if (!seenNodes.add(this)) {
                return;
            }
            this.trueChild.memoizedValues(values, seenNodes);
            this.falseChild.memoizedValues(values, seenNodes);
        }

        @Override
        protected <T> MtBdd<T> memoizedMap(Function<? super Set<E>, ? extends Set<? extends T>> mapper, Map<MtBdd<E>, MtBdd<T>> memoizedCalls) {
            MtBdd<T> mappedNode = memoizedCalls.get(this);
            if (mappedNode != null) {
                return mappedNode;
            }
            mappedNode = Node.of(this.variable, this.trueChild.memoizedMap(mapper, memoizedCalls), this.falseChild.memoizedMap(mapper, memoizedCalls));
            memoizedCalls.put(this, mappedNode);
            return mappedNode;
        }

        @Override
        protected Map<E, BddSet> memoizedInverse(BddSetFactory factory, Map<MtBdd<E>, Map<E, BddSet>> memoizedCalls, IntUnaryOperator mapping) {
            Map<E, BddSet> map = memoizedCalls.get(this);
            if (map != null) {
                return map;
            }
            BddSet trueMask = factory.of(mapping.applyAsInt(this.variable));
            BddSet falseMask = trueMask.complement();
            HashMap newMap = new HashMap();
            this.trueChild.memoizedInverse(factory, memoizedCalls, mapping).forEach((key, set) -> newMap.merge(key, set.intersection(trueMask), BddSet::union));
            this.falseChild.memoizedInverse(factory, memoizedCalls, mapping).forEach((key, set) -> newMap.merge(key, set.intersection(falseMask), BddSet::union));
            memoizedCalls.put(this, newMap);
            return newMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node that = (Node)o;
            return this.hashCode == that.hashCode && this.variable == that.variable && this.trueChild.equals(that.trueChild) && this.falseChild.equals(that.falseChild);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("(V: %d, tt: %s, ff: %s)", this.variable, this.trueChild, this.falseChild);
        }
    }

    public static final class Leaf<E>
    extends MtBdd<E> {
        private static final MtBdd<?> EMPTY = new Leaf(Set.of());
        public final Set<E> value;

        private Leaf(Set<E> value) {
            this.value = value;
        }

        @Override
        public Set<E> get(BitSet valuation) {
            return this.value;
        }

        @Override
        public Set<E> flatValues() {
            return this.value;
        }

        @Override
        protected void memoizedFlatValues(Set<E> values, Set<MtBdd<E>> seenNodes) {
            values.addAll(this.value);
        }

        @Override
        protected void memoizedValues(Set<Set<E>> values, Set<MtBdd<E>> seenNodes) {
            values.add(this.value);
        }

        @Override
        protected <T> MtBdd<T> memoizedMap(Function<? super Set<E>, ? extends Set<? extends T>> mapper, Map<MtBdd<E>, MtBdd<T>> memoizedCalls) {
            return memoizedCalls.computeIfAbsent(this, x -> Leaf.of((Collection)mapper.apply(this.value)));
        }

        @Override
        protected Map<E, BddSet> memoizedInverse(BddSetFactory factory, Map<MtBdd<E>, Map<E, BddSet>> memoizedCalls, IntUnaryOperator mapping) {
            return memoizedCalls.computeIfAbsent(this, x -> Maps.asMap(this.value, y -> factory.of(true)));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Leaf && this.value.equals(((Leaf)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "(" + this.value + ")";
        }
    }
}

