/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import owl.collections.Either;

final class AutoOneOf_Either {
    private AutoOneOf_Either() {
    }

    static <A, B> Either<A, B> left(A left) {
        if (left == null) {
            throw new NullPointerException();
        }
        return new Impl_left(left);
    }

    static <A, B> Either<A, B> right(B right) {
        if (right == null) {
            throw new NullPointerException();
        }
        return new Impl_right(right);
    }

    private static final class Impl_right<A, B>
    extends Parent_<A, B> {
        private final B right;

        Impl_right(B right) {
            this.right = right;
        }

        @Override
        public B right() {
            return this.right;
        }

        public boolean equals(Object x) {
            if (x instanceof Either) {
                Either that = (Either)x;
                return this.type() == that.type() && this.right.equals(that.right());
            }
            return false;
        }

        public int hashCode() {
            return this.right.hashCode();
        }

        @Override
        public Either.Type type() {
            return Either.Type.RIGHT;
        }
    }

    private static final class Impl_left<A, B>
    extends Parent_<A, B> {
        private final A left;

        Impl_left(A left) {
            this.left = left;
        }

        @Override
        public A left() {
            return this.left;
        }

        public boolean equals(Object x) {
            if (x instanceof Either) {
                Either that = (Either)x;
                return this.type() == that.type() && this.left.equals(that.left());
            }
            return false;
        }

        public int hashCode() {
            return this.left.hashCode();
        }

        @Override
        public Either.Type type() {
            return Either.Type.LEFT;
        }
    }

    private static abstract class Parent_<A, B>
    extends Either<A, B> {
        private Parent_() {
        }

        @Override
        public A left() {
            throw new UnsupportedOperationException(this.type().toString());
        }

        @Override
        public B right() {
            throw new UnsupportedOperationException(this.type().toString());
        }
    }
}

