/*
 * Decompiled with CFR 0.152.
 */
package owl.logic.propositional;

import com.google.common.collect.Comparators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class PropositionalFormula<T> {
    private static final Comparator NATURAL_COMPARATOR = Comparators.emptiesLast(Comparator.naturalOrder());

    public abstract boolean evaluate(Set<? extends T> var1);

    public final PropositionalFormula<T> nnf() {
        return this.nnf(false);
    }

    public abstract <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> var1);

    protected abstract PropositionalFormula<T> nnf(boolean var1);

    public static <V> PropositionalFormula<V> constant(boolean constant) {
        return constant ? PropositionalFormula.trueConstant() : PropositionalFormula.falseConstant();
    }

    public static <V> PropositionalFormula<V> trueConstant() {
        return Conjunction.TRUE;
    }

    public static <V> PropositionalFormula<V> falseConstant() {
        return Disjunction.FALSE;
    }

    public abstract int height();

    public boolean isFalse() {
        return this instanceof Disjunction && ((Disjunction)this).disjuncts.isEmpty();
    }

    public boolean isTrue() {
        return this instanceof Conjunction && ((Conjunction)this).conjuncts.isEmpty();
    }

    public final Set<T> variables() {
        return this.countVariables().keySet();
    }

    public abstract boolean containsVariable(T var1);

    public abstract Optional<T> smallestVariable();

    public final Map<T, Integer> countVariables() {
        HashMap occurrences = new HashMap();
        this.countVariables(occurrences);
        return occurrences;
    }

    public abstract Map<T, Polarity> polarity();

    public abstract <R> PropositionalFormula<R> map(Function<? super T, R> var1);

    protected abstract void countVariables(Map<T, Integer> var1);

    protected <S> PropositionalFormula<S> deduplicate(PropositionalFormula<S> newObject) {
        if (this.equals(newObject)) {
            return this;
        }
        return newObject;
    }

    public static <T> List<PropositionalFormula<T>> conjuncts(PropositionalFormula<T> formula) {
        if (formula instanceof Variable || formula instanceof Negation || formula instanceof Disjunction || formula instanceof Biconditional) {
            return List.of(formula);
        }
        return PropositionalFormula.flattenConjunction(new ArrayList<PropositionalFormula<T>>(List.of(formula)));
    }

    public static <T> List<PropositionalFormula<T>> conjuncts(List<? extends PropositionalFormula<T>> formulas) {
        return PropositionalFormula.flattenConjunction(new ArrayList<PropositionalFormula<T>>(formulas));
    }

    private static <T> ArrayList<PropositionalFormula<T>> flattenConjunction(ArrayList<PropositionalFormula<T>> conjuncts) {
        for (int i = 0; i < conjuncts.size(); ++i) {
            PropositionalFormula<T> conjunct = conjuncts.get(i);
            if (conjunct.isFalse()) {
                conjuncts.clear();
                conjuncts.add(PropositionalFormula.falseConstant());
                return conjuncts;
            }
            if (!(conjunct instanceof Conjunction)) continue;
            PropositionalFormula<T> oldElement = conjuncts.remove(i);
            assert (conjunct == oldElement);
            conjuncts.addAll(i, ((Conjunction)conjunct).conjuncts);
            --i;
        }
        return conjuncts;
    }

    public static <T> List<PropositionalFormula<T>> disjuncts(PropositionalFormula<T> formula) {
        if (formula instanceof Variable || formula instanceof Negation || formula instanceof Conjunction || formula instanceof Biconditional) {
            return List.of(formula);
        }
        return PropositionalFormula.flattenDisjunction(new ArrayList<PropositionalFormula<T>>(List.of(formula)));
    }

    public static <T> List<PropositionalFormula<T>> disjuncts(List<? extends PropositionalFormula<T>> formulas) {
        return PropositionalFormula.flattenDisjunction(new ArrayList<PropositionalFormula<T>>(formulas));
    }

    private static <T> ArrayList<PropositionalFormula<T>> flattenDisjunction(ArrayList<PropositionalFormula<T>> disjuncts) {
        for (int i = 0; i < disjuncts.size(); ++i) {
            PropositionalFormula<T> disjunct = disjuncts.get(i);
            if (disjunct.isTrue()) {
                disjuncts.clear();
                disjuncts.add(PropositionalFormula.trueConstant());
                return disjuncts;
            }
            if (!(disjunct instanceof Disjunction)) continue;
            PropositionalFormula<T> oldElement = disjuncts.remove(i);
            assert (disjunct == oldElement);
            disjuncts.addAll(i, ((Disjunction)disjunct).disjuncts);
            --i;
        }
        return disjuncts;
    }

    public static final class Variable<T>
    extends PropositionalFormula<T> {
        public final T variable;

        public Variable(T variable) {
            this.variable = Objects.requireNonNull(variable);
        }

        public static <T> Variable<T> of(T variable) {
            return new Variable<T>(variable);
        }

        @Override
        public Map<T, Polarity> polarity() {
            HashMap<T, Polarity> polarity = new HashMap<T, Polarity>();
            polarity.put(this.variable, Polarity.POSITIVE);
            return polarity;
        }

        @Override
        protected void countVariables(Map<T, Integer> occurrences) {
            occurrences.compute(this.variable, (x, y) -> y == null ? 1 : y + 1);
        }

        @Override
        public <R> PropositionalFormula<R> map(Function<? super T, R> mapper) {
            return this.deduplicate(Variable.of(mapper.apply(this.variable)));
        }

        @Override
        public int height() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Variable)) {
                return false;
            }
            Variable that = (Variable)obj;
            return this.variable.equals(that.variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public String toString() {
            return this.variable.toString();
        }

        @Override
        public <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> substitution) {
            return this.deduplicate(substitution.apply(this.variable));
        }

        @Override
        protected PropositionalFormula<T> nnf(boolean negated) {
            return negated ? new Negation(this) : this;
        }

        @Override
        public boolean evaluate(Set<? extends T> assignment) {
            return assignment.contains(this.variable);
        }

        @Override
        public boolean containsVariable(T variable) {
            return this.variable.equals(variable);
        }

        @Override
        public Optional<T> smallestVariable() {
            return Optional.of(this.variable);
        }
    }

    public static final class Negation<T>
    extends PropositionalFormula<T> {
        public final PropositionalFormula<T> operand;

        public Negation(PropositionalFormula<T> operand) {
            this.operand = operand;
        }

        public static <T> PropositionalFormula<T> of(PropositionalFormula<T> operand) {
            if (operand.isTrue()) {
                return Negation.falseConstant();
            }
            if (operand.isFalse()) {
                return Negation.trueConstant();
            }
            if (operand instanceof Negation) {
                return ((Negation)operand).operand;
            }
            return new Negation<T>(operand);
        }

        @Override
        protected PropositionalFormula<T> nnf(boolean negated) {
            return this.operand.nnf(!negated);
        }

        @Override
        public boolean evaluate(Set<? extends T> assignment) {
            return !this.operand.evaluate(assignment);
        }

        @Override
        public Map<T, Polarity> polarity() {
            Map<T, Polarity> polarity = this.operand.polarity();
            polarity.replaceAll((x, y) -> {
                switch (y) {
                    case POSITIVE: {
                        return Polarity.NEGATIVE;
                    }
                    case NEGATIVE: {
                        return Polarity.POSITIVE;
                    }
                }
                return Polarity.MIXED;
            });
            return polarity;
        }

        @Override
        protected void countVariables(Map<T, Integer> occurrences) {
            this.operand.countVariables(occurrences);
        }

        @Override
        public <R> PropositionalFormula<R> map(Function<? super T, R> mapper) {
            return this.deduplicate(Negation.of(this.operand.map(mapper)));
        }

        @Override
        public int height() {
            return this.operand.height() + 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Negation)) {
                return false;
            }
            Negation that = (Negation)obj;
            return this.operand.equals(that.operand);
        }

        public int hashCode() {
            return 31 * Negation.class.hashCode() + this.operand.hashCode();
        }

        public String toString() {
            return "\u00ac" + this.operand;
        }

        @Override
        public <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> substitution) {
            return this.deduplicate(Negation.of(this.operand.substitute(substitution)));
        }

        @Override
        public boolean containsVariable(T variable) {
            return this.operand.containsVariable(variable);
        }

        @Override
        public Optional<T> smallestVariable() {
            return this.operand.smallestVariable();
        }
    }

    public static final class Disjunction<T>
    extends PropositionalFormula<T> {
        private static Disjunction<?> FALSE = new Disjunction(List.of());
        public final List<PropositionalFormula<T>> disjuncts;

        private Disjunction(List<? extends PropositionalFormula<T>> disjuncts) {
            this.disjuncts = List.copyOf(disjuncts);
            assert (this.disjuncts.stream().noneMatch(Disjunction.class::isInstance)) : this.disjuncts;
        }

        @SafeVarargs
        public static <T> PropositionalFormula<T> of(T ... operands) {
            ArrayList<PropositionalFormula<T>> disjuncts = new ArrayList<PropositionalFormula<T>>();
            for (T operand : operands) {
                disjuncts.add(Variable.of(operand));
            }
            return Disjunction.ofTrusted(disjuncts);
        }

        @SafeVarargs
        public static <T> PropositionalFormula<T> of(PropositionalFormula<T> ... operands) {
            return Disjunction.of(Arrays.asList(operands));
        }

        public static <T> PropositionalFormula<T> of(List<? extends PropositionalFormula<T>> disjuncts) {
            return Disjunction.ofTrusted(new ArrayList<PropositionalFormula<T>>(disjuncts));
        }

        private static <T> PropositionalFormula<T> ofTrusted(ArrayList<PropositionalFormula<T>> disjuncts) {
            ArrayList<PropositionalFormula<T>> normalisedDisjuncts = PropositionalFormula.flattenDisjunction(disjuncts);
            switch (normalisedDisjuncts.size()) {
                case 0: {
                    return Disjunction.falseConstant();
                }
                case 1: {
                    return normalisedDisjuncts.iterator().next();
                }
            }
            return new Disjunction<T>(List.copyOf(normalisedDisjuncts));
        }

        @Override
        public boolean evaluate(Set<? extends T> assignment) {
            for (PropositionalFormula<? extends T> propositionalFormula : this.disjuncts) {
                if (!propositionalFormula.evaluate(assignment)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected PropositionalFormula<T> nnf(boolean negated) {
            return negated ? Conjunction.ofTrusted(this.mapOperands(x -> x.nnf(negated))) : this.deduplicate(Disjunction.ofTrusted(this.mapOperands(x -> x.nnf(negated))));
        }

        @Override
        public Map<T, Polarity> polarity() {
            HashMap polarityMap = new HashMap();
            for (PropositionalFormula<T> disjunct : this.disjuncts) {
                disjunct.polarity().forEach((variable, polarity) -> polarityMap.compute(variable, (oldKey, oldPolarity) -> {
                    if (polarity == oldPolarity || oldPolarity == null) {
                        return polarity;
                    }
                    return Polarity.MIXED;
                }));
            }
            return polarityMap;
        }

        @Override
        protected void countVariables(Map<T, Integer> occurrences) {
            this.disjuncts.forEach(x -> x.countVariables(occurrences));
        }

        @Override
        public <R> PropositionalFormula<R> map(Function<? super T, R> mapper) {
            return this.deduplicate(Disjunction.ofTrusted(this.mapOperands(x -> x.map(mapper))));
        }

        @Override
        public int height() {
            int height = 0;
            for (PropositionalFormula<T> disjunct : this.disjuncts) {
                height = Math.max(height, disjunct.height() + 1);
            }
            return height;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Disjunction)) {
                return false;
            }
            Disjunction that = (Disjunction)obj;
            return this.disjuncts.equals(that.disjuncts);
        }

        public int hashCode() {
            return 31 * Disjunction.class.hashCode() + this.disjuncts.hashCode();
        }

        public String toString() {
            switch (this.disjuncts.size()) {
                case 0: {
                    return "ff";
                }
                case 1: {
                    return this.disjuncts.get(0).toString();
                }
            }
            return this.disjuncts.stream().map(Object::toString).collect(Collectors.joining(" \u2228 ", "(", ")"));
        }

        @Override
        public <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> substitution) {
            return this.deduplicate(Disjunction.ofTrusted(this.mapOperands(x -> x.substitute(substitution))));
        }

        @Override
        public boolean containsVariable(T variable) {
            int s = this.disjuncts.size();
            for (int i = 0; i < s; ++i) {
                if (!this.disjuncts.get(i).containsVariable(variable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Optional<T> smallestVariable() {
            Optional smallestVariableOfDisjunct = Optional.empty();
            for (PropositionalFormula<T> disjunct : this.disjuncts) {
                Optional<T> smallestVariable = disjunct.smallestVariable();
                if (NATURAL_COMPARATOR.compare(smallestVariable, smallestVariableOfDisjunct) >= 0) continue;
                smallestVariableOfDisjunct = smallestVariable;
            }
            return smallestVariableOfDisjunct;
        }

        private <S> ArrayList<PropositionalFormula<S>> mapOperands(Function<PropositionalFormula<T>, PropositionalFormula<S>> mapper) {
            ArrayList<PropositionalFormula<S>> operands = new ArrayList<PropositionalFormula<S>>(this.disjuncts.size());
            for (PropositionalFormula<T> conjunct : this.disjuncts) {
                operands.add(mapper.apply(conjunct));
            }
            return operands;
        }
    }

    public static final class Conjunction<T>
    extends PropositionalFormula<T> {
        private static Conjunction<?> TRUE = new Conjunction(List.of());
        public final List<PropositionalFormula<T>> conjuncts;

        private Conjunction(List<? extends PropositionalFormula<T>> conjuncts) {
            this.conjuncts = List.copyOf(conjuncts);
            assert (this.conjuncts.stream().noneMatch(Conjunction.class::isInstance)) : this.conjuncts;
        }

        @SafeVarargs
        public static <T> PropositionalFormula<T> of(PropositionalFormula<T> ... operands) {
            return Conjunction.of(Arrays.asList(operands));
        }

        public static <T> PropositionalFormula<T> of(List<? extends PropositionalFormula<T>> conjuncts) {
            return Conjunction.ofTrusted(new ArrayList<PropositionalFormula<T>>(conjuncts));
        }

        private static <T> PropositionalFormula<T> ofTrusted(ArrayList<PropositionalFormula<T>> conjuncts) {
            ArrayList<PropositionalFormula<T>> normalisedConjuncts = PropositionalFormula.flattenConjunction(conjuncts);
            switch (normalisedConjuncts.size()) {
                case 0: {
                    return Conjunction.trueConstant();
                }
                case 1: {
                    return normalisedConjuncts.iterator().next();
                }
            }
            return new Conjunction<T>(List.copyOf(normalisedConjuncts));
        }

        @Override
        public boolean evaluate(Set<? extends T> assignment) {
            for (PropositionalFormula<? extends T> propositionalFormula : this.conjuncts) {
                if (propositionalFormula.evaluate(assignment)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected PropositionalFormula<T> nnf(boolean negated) {
            return negated ? Disjunction.ofTrusted(this.mapOperands(x -> x.nnf(negated))) : this.deduplicate(Conjunction.ofTrusted(this.mapOperands(x -> x.nnf(negated))));
        }

        @Override
        public Map<T, Polarity> polarity() {
            HashMap polarityMap = new HashMap();
            for (PropositionalFormula<T> conjunct : this.conjuncts) {
                conjunct.polarity().forEach((variable, polarity) -> polarityMap.compute(variable, (oldKey, oldPolarity) -> {
                    if (polarity == oldPolarity || oldPolarity == null) {
                        return polarity;
                    }
                    return Polarity.MIXED;
                }));
            }
            return polarityMap;
        }

        @Override
        protected void countVariables(Map<T, Integer> occurrences) {
            this.conjuncts.forEach(x -> x.countVariables(occurrences));
        }

        @Override
        public <R> PropositionalFormula<R> map(Function<? super T, R> mapper) {
            return this.deduplicate(Conjunction.ofTrusted(this.mapOperands(x -> x.map(mapper))));
        }

        @Override
        public int height() {
            int height = 0;
            for (PropositionalFormula<T> conjunct : this.conjuncts) {
                height = Math.max(height, conjunct.height() + 1);
            }
            return height;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Conjunction)) {
                return false;
            }
            Conjunction that = (Conjunction)obj;
            return this.conjuncts.equals(that.conjuncts);
        }

        public int hashCode() {
            return 31 * Conjunction.class.hashCode() + this.conjuncts.hashCode();
        }

        public String toString() {
            switch (this.conjuncts.size()) {
                case 0: {
                    return "tt";
                }
                case 1: {
                    return this.conjuncts.get(0).toString();
                }
            }
            return this.conjuncts.stream().map(Object::toString).collect(Collectors.joining(" \u2227 ", "(", ")"));
        }

        @Override
        public <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> substitution) {
            return this.deduplicate(Conjunction.ofTrusted(this.mapOperands(x -> x.substitute(substitution))));
        }

        @Override
        public boolean containsVariable(T variable) {
            int s = this.conjuncts.size();
            for (int i = 0; i < s; ++i) {
                if (!this.conjuncts.get(i).containsVariable(variable)) continue;
                return true;
            }
            return false;
        }

        private <S> ArrayList<PropositionalFormula<S>> mapOperands(Function<PropositionalFormula<T>, PropositionalFormula<S>> mapper) {
            ArrayList<PropositionalFormula<S>> operands = new ArrayList<PropositionalFormula<S>>(this.conjuncts.size());
            for (PropositionalFormula<T> conjunct : this.conjuncts) {
                operands.add(mapper.apply(conjunct));
            }
            return operands;
        }

        @Override
        public Optional<T> smallestVariable() {
            Optional smallestVariableOfConjunct = Optional.empty();
            for (PropositionalFormula<T> conjunct : this.conjuncts) {
                Optional<T> smallestVariable = conjunct.smallestVariable();
                if (NATURAL_COMPARATOR.compare(smallestVariable, smallestVariableOfConjunct) >= 0) continue;
                smallestVariableOfConjunct = smallestVariable;
            }
            return smallestVariableOfConjunct;
        }
    }

    public static final class Biconditional<T>
    extends PropositionalFormula<T> {
        public final PropositionalFormula<T> leftOperand;
        public final PropositionalFormula<T> rightOperand;

        private Biconditional(PropositionalFormula<T> leftOperand, PropositionalFormula<T> rightOperand) {
            this.leftOperand = leftOperand;
            this.rightOperand = rightOperand;
        }

        public static <T> PropositionalFormula<T> of(PropositionalFormula<T> leftOperand, PropositionalFormula<T> rightOperand) {
            if (leftOperand.isTrue()) {
                return rightOperand;
            }
            if (leftOperand.isFalse()) {
                return Negation.of(rightOperand);
            }
            if (rightOperand.isTrue()) {
                return leftOperand;
            }
            if (rightOperand.isFalse()) {
                return Negation.of(leftOperand);
            }
            if (leftOperand.equals(rightOperand)) {
                return Biconditional.trueConstant();
            }
            if (leftOperand instanceof Negation && rightOperand instanceof Negation) {
                return Biconditional.of(((Negation)leftOperand).operand, ((Negation)rightOperand).operand);
            }
            return new Biconditional<T>(leftOperand, rightOperand);
        }

        @Override
        public boolean evaluate(Set<? extends T> assignment) {
            return this.leftOperand.evaluate(assignment) == this.rightOperand.evaluate(assignment);
        }

        @Override
        public <S> PropositionalFormula<S> substitute(Function<? super T, ? extends PropositionalFormula<S>> substitution) {
            return this.deduplicate(Biconditional.of(this.leftOperand.substitute(substitution), this.rightOperand.substitute(substitution)));
        }

        @Override
        protected PropositionalFormula<T> nnf(boolean negated) {
            return Disjunction.of(Conjunction.of(this.leftOperand.nnf(false), this.rightOperand.nnf(false)), Conjunction.of(this.leftOperand.nnf(true), this.rightOperand.nnf(true))).nnf(negated);
        }

        @Override
        public Map<T, Polarity> polarity() {
            Map<T, Polarity> polarity = this.rightOperand.polarity();
            polarity.putAll(this.leftOperand.polarity());
            polarity.replaceAll((x, y) -> Polarity.MIXED);
            return polarity;
        }

        @Override
        public <R> PropositionalFormula<R> map(Function<? super T, R> mapper) {
            return this.deduplicate(Biconditional.of(this.leftOperand.map(mapper), this.rightOperand.map(mapper)));
        }

        @Override
        protected void countVariables(Map<T, Integer> occurrences) {
            this.leftOperand.countVariables(occurrences);
            this.rightOperand.countVariables(occurrences);
        }

        @Override
        public int height() {
            return Math.max(this.leftOperand.height(), this.rightOperand.height()) + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Biconditional)) {
                return false;
            }
            Biconditional that = (Biconditional)o;
            return this.leftOperand.equals(that.leftOperand) && this.rightOperand.equals(that.rightOperand);
        }

        public int hashCode() {
            return Objects.hash(Biconditional.class, this.leftOperand, this.rightOperand);
        }

        @Override
        public boolean containsVariable(T variable) {
            return this.leftOperand.containsVariable(variable) || this.rightOperand.containsVariable(variable);
        }

        @Override
        public Optional<T> smallestVariable() {
            return (Optional)Comparators.min(this.leftOperand.smallestVariable(), this.rightOperand.smallestVariable(), (Comparator)NATURAL_COMPARATOR);
        }
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE,
        MIXED;

    }
}

