/*
 *  file generic_visitor.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>

// --------------------------  Element<I>


template< class I >
class Element
{
public:
  template< class Visitor >
  void Accept( Visitor v )
    {
      v.Visit( static_cast<I&>(*this) );
    }
};



// --------------------------  ConcreteElementA



class ConcreteElementA : public Element< ConcreteElementA >
{ // ...
};



// --------------------------  ConcreteElementB



class ConcreteElementB : public Element< ConcreteElementB >
{ // ...
};



// --------------------------  ConcreteVisitor1



// decl

class ConcreteVisitor1
{
public:
  template< class ConcreteElement >
  void Visit( ConcreteElement& e );
};



// impl

template<>
void ConcreteVisitor1::Visit( ConcreteElementA& e )
{
  std::cout << "ConcreteVisitor1::Visit( ConcreteElementA& )" << std::endl;
}

template<>
void ConcreteVisitor1::Visit( ConcreteElementB& e )
{
  std::cout << "ConcreteVisitor1::Visit( ConcreteElementB& )" << std::endl;
}



// --------------------------  main



int main()
{
  ConcreteElementA e;
  e.Accept( ConcreteVisitor1() );
}
