/*
 *  file main.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 *  lrde@epita.fr
 */


#include <iostream>
using namespace std;

#include "rgb.hh"
#include "image2d.hh"
#include "op.hh"
#include "func.hh"



int main()
{

  Image2D< rgb<float> > ima( 7, 7 );
  ima.prettify();
  cout << "original:" << endl 
       << ima << endl;

  //------------------------------
  
  op<plus>::on( ima, 1 );

  cout << "plus (1,1,1):" << endl
       << ima << endl;

  //------------------------------

  op<plus,get_red>::on( ima, 2 );

  cout << "plus (2,,):" << endl
       << ima << endl;

  //------------------------------

  Pred_equal< float >  pred2( 3.f );

  op<plus, get_red, Pred_equal< float > >::on( ima, 3, pred2 );

  cout << "plus (3,,) if (3,,)" << endl
       << ima << endl;

}
