#include <iostream>
using std::cout;
using std::endl;


//
//  ``Deep'' hierarchy and the Curiously Recurring Template Pattern
//
//      A
//    /   \
//   B1    B2
//         |
//         B20
//
//////////////////////////////////////////////////////////////////////


template<class T>
struct A {
  T& self() {
    return static_cast<T&>(*this);
  }
  void m() {
    self().n();
    // ...
  }
};


struct B1 : public A<B1> {
  void n() { cout << "B1::n" << endl; }
};


struct B2 : public A<B2> {
  void n() { cout << "B2::n" << endl; }
};


struct B20 : public B2 {
  void n() { cout << "B20::n" << endl; }
};



//
//  foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(T& a) {
  a.m();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main()
{
  B1  b1;   foo(b1);   // B1::n
  B2  b2;   foo(b2);   // B2::n
  B20 b20;  foo(b20);  // B2::n!
}
