#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"

//
//  ``Deep'' recurring hierarchy and the CRTP
//
//      A*
//    /   \
//   B1*   B2*
//          |
//         B20*
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct A : public Void< A<I> > {
  void m() {
    to_exact(this)->n();
  }
};


template<class I = Bottom>
struct B1 : public A< B1<I> > {
  void n() { cout << "B1::n" << endl; }
};


template<class I = Bottom>
struct B2 : public A< B2<I> > {
  void n() { cout << "B2::n" << endl; }
};


template<class I = Bottom>
struct B20 : public B2< B20<I> > {
  void n() { cout << "B20::n" << endl; }
};



//
//  foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(T& a) {
  a.m();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  B1<>  b1;   foo(b1);   // B1::n
  B2<>  b2;   foo(b2);   // B2::n
  B20<> b20;  foo(b20);  // B20::n
}
