
#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"


//
//  ``Horizontal'' recurring hierarchy:
//
//     A*
//    /  \
//  B1*   B2*
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
class A : public Void< A<I> > {
public:
  void echo() {
    cout << "A" << endl;
  }
};


template<class I = Bottom>
class B1 : public A< B1<I> > {
public:
  void echo() {
    cout << "B1" << endl;
  }
};


template<class I = Bottom>
class B2 : public A< B2<I> > {
public:
  void echo() {
    cout << "B2" << endl;
  }
};



//
//  strong statically typed foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(A<T>& a) {
  to_exact(a).echo();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  A<>  a;   foo(a);
  B1<> b1;  foo(b1);
  B2<> b2;  foo(b2);
}
