// this file goes with the paper:
// Alexandre Duret-Lutz, Thierry Geraud, and Akim Demaille.
// Generic Design Patterns in C++. In the Proceedings of the 6th
// USENIX Conference on Object-Oriented Technologies and Systems (COOTS),
// pages 189-202, San Antonio, Texas, USA, January-February 2001.


#include <iostream>
using std::cout;
using std::endl;



template<class I>
class SuperiorOf {
protected:
  SuperiorOf() {
  }
  I& Self() {
    return static_cast<I&>(*this);
  }
};



template<class I>
class AbstractClass : public SuperiorOf<I>
{
public:
  void TemplateMethod() {
    // ...
    PrimitiveOperation1();
    // ...
    PrimitiveOperation2();
    // ...
  }
  void PrimitiveOperation1() {
    Self().PrimitiveOperation1_impl();
  }
  void PrimitiveOperation2() {
    Self().PrimitiveOperation2_impl();
  }
};



class ConcreteClass : public AbstractClass<ConcreteClass>
{
public:
  void PrimitiveOperation1_impl() {
    cout << "ConcreteClass::PrimitiveOperation1" << endl;
  }
  void PrimitiveOperation2_impl() {
    cout << "ConcreteClass::PrimitiveOperation2" << endl;
  }
};



int main()
{
  ConcreteClass obj;
  obj.TemplateMethod();
}
