/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.tools.mocks.MockPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPluginAttribute
extends MockPluginElement<PluginAttribute>
implements PluginAttribute {
    private LinkedList<PluginAttribute> subAttributes = new LinkedList();
    private PluginAttribute superAttribute;
    private String value;

    public MockPluginAttribute() {
    }

    public MockPluginAttribute(String id, String aValue) {
        this.setId(id);
        this.value = aValue;
    }

    @Override
    public PluginAttribute getSubAttribute(String id) {
        for (PluginAttribute attr : this.subAttributes) {
            if (!attr.getId().equals(id)) continue;
            return attr;
        }
        throw new IllegalArgumentException("unknown attribute ID " + id);
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes() {
        return Collections.unmodifiableCollection(this.subAttributes);
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes(String id) {
        LinkedList<PluginAttribute> result = new LinkedList<PluginAttribute>();
        for (PluginAttribute attr : this.subAttributes) {
            if (!attr.getId().equals(id)) continue;
            result.add(attr);
        }
        return result;
    }

    public MockPluginAttribute addSubAttribute(PluginAttribute attribute) {
        this.subAttributes.add(attribute);
        return this;
    }

    @Override
    public PluginAttribute getSuperAttribute() {
        return this.superAttribute;
    }

    public MockPluginAttribute setSuperAttribute(PluginAttribute attribute) {
        this.superAttribute = attribute;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public MockPluginAttribute setValue(String attributeValue) {
        this.value = attributeValue;
        return this;
    }
}

