/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.IOException;
import org.onemind.commons.java.datastructure.MruMap;
import org.onemind.jxp.CachedJxpPage;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageNotFoundException;
import org.onemind.jxp.JxpPageParseException;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.parser.AstJxpDocument;

public abstract class CachingPageSource
extends JxpPageSource {
    private MruMap _pageCache;
    private boolean _caching = true;
    private boolean _invalidateCacheOnParseError = false;

    public CachingPageSource() {
        this(200);
    }

    public CachingPageSource(int cacheSize) {
        this._pageCache = new MruMap((long)cacheSize, 0L);
    }

    public final JxpPage getJxpPage(String id) throws JxpPageNotFoundException {
        JxpPage page = null;
        if (this._caching && (page = (JxpPage)this._pageCache.get(id)) != null) {
            return page;
        }
        page = this.loadJxpPage(id);
        if (this._caching && page != null) {
            this._pageCache.put(id, page);
        }
        return page;
    }

    protected final void invalidatePageCache(JxpPage page) {
        this._pageCache.put(page.getName(), (Object)null);
    }

    protected abstract CachedJxpPage loadJxpPage(String var1) throws JxpPageNotFoundException;

    public final boolean isCaching() {
        return this._caching;
    }

    public final void setCaching(boolean b) {
        this._caching = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstJxpDocument getJxpDocument(JxpPage page) throws JxpPageParseException {
        CachedJxpPage cachedPage = (CachedJxpPage)page;
        if (cachedPage.getDocument() == null) {
            if (cachedPage.hasParseError()) {
                throw cachedPage.getParseException();
            }
            CachedJxpPage cachedJxpPage = cachedPage;
            synchronized (cachedJxpPage) {
                if (cachedPage.getDocument() == null) {
                    if (cachedPage.hasParseError()) {
                        throw cachedPage.getParseException();
                    }
                    try {
                        AstJxpDocument doc = this.parseJxpDocument(page);
                        cachedPage.setDocument(doc);
                    }
                    catch (JxpPageParseException e) {
                        cachedPage.setParseException(e);
                        if (this._invalidateCacheOnParseError) {
                            this.invalidatePageCache(page);
                        }
                        throw e;
                    }
                }
            }
        }
        return cachedPage.getDocument();
    }

    protected abstract AstJxpDocument parseJxpDocument(JxpPage var1) throws JxpPageParseException;

    public final boolean isJxpPageCached(String id) {
        return this._pageCache.containsKey(id);
    }

    public StringBuffer getErrorSource(JxpPage page, int line, int col) throws IOException {
        StringBuffer sb = new StringBuffer("Error at page ");
        sb.append(page.getName());
        sb.append(" at line ");
        sb.append(line);
        sb.append(", column ");
        sb.append(col);
        return sb;
    }
}

