/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import org.onemind.commons.java.lang.Null;

public final class Evaluator {
    private static final short INT_PRECISION = 0;
    private static final short FLOAT_PRECISION = 1;
    private static final short LONG_PRECISION = 2;
    private static final short DOUBLE_PRECISION = 3;

    private Evaluator() {
    }

    public static Object plus(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return new Integer(n1.intValue() + n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() + n2.longValue());
            }
            case 1: {
                return new Float(n1.floatValue() + n2.floatValue());
            }
            case 3: {
                return new Double(n1.doubleValue() + n2.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    private static short getPrecision(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return 3;
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return 1;
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return 2;
        }
        return 0;
    }

    private static Number toNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalArgumentException(o + " is not a number");
    }

    public static Object minus(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return new Integer(n1.intValue() - n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() - n2.longValue());
            }
            case 1: {
                return new Float(n1.floatValue() - n2.floatValue());
            }
            case 3: {
                return new Double(n1.doubleValue() - n2.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    public static Object multiply(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return new Integer(n1.intValue() * n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() * n2.longValue());
            }
            case 1: {
                return new Float(n1.floatValue() * n2.floatValue());
            }
            case 3: {
                return new Double(n1.doubleValue() * n2.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    public static Object divide(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return new Integer(n1.intValue() / n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() / n2.longValue());
            }
            case 1: {
                return new Float(n1.floatValue() / n2.floatValue());
            }
            case 3: {
                return new Double(n1.doubleValue() / n2.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    public static Object remainder(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return new Integer(n1.intValue() % n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() % n2.longValue());
            }
            case 1: {
                return new Float(n1.floatValue() % n2.floatValue());
            }
            case 3: {
                return new Double(n1.doubleValue() % n2.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    public static Object negate(Object a1) {
        Number n1 = Evaluator.toNumber(a1);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(-n1.intValue());
            }
            case 2: {
                return new Long(-n1.longValue());
            }
            case 1: {
                return new Float(-n1.floatValue());
            }
            case 3: {
                return new Double(-n1.doubleValue());
            }
        }
        throw new InternalError("Internal error");
    }

    public static Boolean eq(Object a1, Object a2) {
        if (a1 instanceof Number && a2 instanceof Number) {
            return a1.equals(a2);
        }
        if (a1 instanceof Boolean && a2 instanceof Boolean) {
            return a1.equals(a2);
        }
        if (!(a1 != null && a1 != Null.instance || a2 != null && a2 != Null.instance)) {
            return Boolean.TRUE;
        }
        return a1 == a2;
    }

    public static Boolean ne(Object a1, Object a2) {
        if (a1 instanceof Number && a2 instanceof Number) {
            return !a1.equals(a2);
        }
        if (a1 instanceof Boolean && a2 instanceof Boolean) {
            return !a1.equals(a2);
        }
        if (!(a1 != null && a1 != Null.instance || a2 != null && a2 != Null.instance)) {
            return Boolean.FALSE;
        }
        return a1 != a2;
    }

    public static Boolean lt(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return n1.intValue() < n2.intValue();
            }
            case 2: {
                return n1.longValue() < n2.longValue();
            }
            case 1: {
                return n1.floatValue() < n2.floatValue();
            }
            case 3: {
                return n1.doubleValue() < n2.doubleValue();
            }
        }
        throw new InternalError("Internal error");
    }

    public static Boolean le(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return n1.intValue() <= n2.intValue();
            }
            case 2: {
                return n1.longValue() <= n2.longValue();
            }
            case 1: {
                return n1.floatValue() <= n2.floatValue();
            }
            case 3: {
                return n1.doubleValue() <= n2.doubleValue();
            }
        }
        throw new InternalError("Internal error");
    }

    public static Boolean gt(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return n1.intValue() > n2.intValue();
            }
            case 2: {
                return n1.longValue() > n2.longValue();
            }
            case 1: {
                return n1.floatValue() > n2.floatValue();
            }
            case 3: {
                return n1.doubleValue() > n2.doubleValue();
            }
        }
        throw new InternalError("Internal error");
    }

    public static Boolean ge(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n2)) {
            case 0: {
                return n1.intValue() >= n2.intValue();
            }
            case 2: {
                return n1.longValue() >= n2.longValue();
            }
            case 1: {
                return n1.floatValue() >= n2.floatValue();
            }
            case 3: {
                return n1.doubleValue() >= n2.doubleValue();
            }
        }
        throw new InternalError("Internal error");
    }

    public static Boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException(o + " is not boolean");
    }

    public static Object bitwiseComplement(Object o) {
        Number n1 = Evaluator.toNumber(o);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(~n1.intValue());
            }
            case 2: {
                return new Long(n1.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new IllegalArgumentException("Cannot apply bitwise complement operation on float/double value");
    }

    public static Object leftShift(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() << n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() << n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply << operator on float/double value");
    }

    public static Object rightSignedShift(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() >> n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() >> n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply >> operator on float/double value");
    }

    public static Object rightUnsignedShift(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() >>> n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() >>> n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply >>> operator on float/double value");
    }

    public static Object bitwiseAnd(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() & n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() & (long)n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply & operator on float/double value");
    }

    public static Object bitwiseOr(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() | n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() | (long)n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply | operator on float/double value");
    }

    public static Object bitwiseXOr(Object a1, Object a2) {
        Number n1 = Evaluator.toNumber(a1);
        Number n2 = Evaluator.toNumber(a2);
        switch (Evaluator.getPrecision(n1, n1)) {
            case 0: {
                return new Integer(n1.intValue() ^ n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() ^ (long)n2.intValue());
            }
        }
        throw new IllegalArgumentException("Cannot apply ^ operator on float/double value");
    }
}

