/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.sets;

import jdd.bdd.BDDUtil;
import jdd.bdd.sets.BDDUniverse;
import jdd.util.Test;
import jdd.util.math.Digits;

class SubDomain {
    private BDDUniverse universe;
    int bits;
    int size;
    int all;
    int[] vars;
    int[] numbers;

    SubDomain(BDDUniverse bDDUniverse, int n) {
        int n2;
        Test.checkInequality(n, 0, "Empty subdomain :(");
        this.universe = bDDUniverse;
        this.size = n;
        this.bits = Digits.log2_ceil(n);
        this.vars = new int[this.bits];
        this.numbers = new int[n];
        for (n2 = 0; n2 < this.bits; ++n2) {
            this.vars[n2] = bDDUniverse.createVar();
        }
        this.all = 0;
        for (n2 = 0; n2 < n; ++n2) {
            this.numbers[n2] = BDDUtil.numberToBDD(bDDUniverse, this.vars, n2);
            int n3 = bDDUniverse.ref(bDDUniverse.or(this.all, this.numbers[n2]));
            bDDUniverse.deref(this.all);
            this.all = n3;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int find(int n) {
        if (n == 1 || n == 0 || n == this.all) {
            return 0;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.universe.and(n, this.numbers[i]) != n) continue;
            return i;
        }
        return -1;
    }
}

