/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.jre;

import java.util.Date;
import java.util.Properties;
import jdd.util.JDDConsole;
import jdd.util.math.Digits;

public class JREInfo {
    public static Runtime rt = Runtime.getRuntime();

    public static long usedMemory() {
        return rt.totalMemory() - rt.freeMemory();
    }

    public static long totalMemory() {
        return rt.totalMemory();
    }

    public static long freeMemory() {
        return rt.freeMemory();
    }

    public static long maxMemory() {
        return rt.maxMemory();
    }

    public static void show() {
        Properties properties = System.getProperties();
        JDDConsole.out.print("Using " + properties.getProperty("java.vendor") + " JRE " + properties.getProperty("java.version"));
        String string = properties.getProperty("java.compiler");
        if (string != null) {
            JDDConsole.out.print(", " + string + " JIT in");
        }
        JDDConsole.out.println(" " + properties.getProperty("java.vm.name"));
        JDDConsole.out.println("OS " + properties.getProperty("os.name") + " on " + rt.availableProcessors() + " " + properties.getProperty("os.arch") + " CPU(s) (one used), speed " + JREInfo.speed() + " JDD-MIPS");
        JDDConsole.out.print("Total memory: ");
        Digits.printNumber1024(rt.maxMemory());
        JDDConsole.out.print(", memory currently reserved by the JVM: ");
        Digits.printNumber1024(JREInfo.usedMemory());
        JDDConsole.out.println();
        JDDConsole.out.println("Using JDD build 103 on " + new Date().toString() + "\n\n");
    }

    public static double speed() {
        JREInfo.speed_();
        return JREInfo.speed_();
    }

    private static double speed_() {
        long l;
        long l2 = System.currentTimeMillis();
        while ((l = System.currentTimeMillis()) == l2) {
        }
        long l3 = 0L;
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < j; ++k) {
                    l3 = l3 + (long)i + (long)(j * k);
                }
            }
        }
        long l4 = System.currentTimeMillis();
        double d = l4 - l;
        if (d == 0.0) {
            return -1.0;
        }
        return (double)((int)(3.0E8 / d)) / 100.0;
    }

    public static void main(String[] stringArray) {
        JREInfo.show();
    }
}

