/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.java.plugin.ObjectFactory;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.Version;
import org.java.plugin.util.IoUtil;

public class PluginInfoTask
extends Task {
    private File manifest;
    private String propertyId;
    private String propertyVersion;
    private String propertyVendor;
    private String propertyPluginId;
    private String propertyPluginVersion;
    private String propertyMatchingRule;

    public void setManifest(File aManifest) {
        this.manifest = aManifest;
    }

    public void setPropertyId(String propertyName) {
        this.propertyId = propertyName;
    }

    public void setPropertyVersion(String propertyName) {
        this.propertyVersion = propertyName;
    }

    public void setPropertyVendor(String propertyName) {
        this.propertyVendor = propertyName;
    }

    public void setPropertyPluginId(String propertyName) {
        this.propertyPluginId = propertyName;
    }

    public void setPropertyPluginVersion(String propertyName) {
        this.propertyPluginVersion = propertyName;
    }

    public void setPropertyMatchingRule(String propertyName) {
        this.propertyMatchingRule = propertyName;
    }

    public void execute() throws BuildException {
        Object value;
        Version version;
        ManifestInfo manifestInfo;
        URL url;
        if (this.manifest == null) {
            throw new BuildException("manifest attribute must be set!", this.getLocation());
        }
        try {
            url = IoUtil.file2url(this.manifest);
        }
        catch (MalformedURLException mue) {
            throw new BuildException("failed converting file " + this.manifest + " to URL", (Throwable)mue, this.getLocation());
        }
        try {
            manifestInfo = ObjectFactory.newInstance().createRegistry().readManifestInfo(url);
        }
        catch (ManifestProcessingException mpe) {
            throw new BuildException("failed reading data from manifest " + url, (Throwable)mpe, this.getLocation());
        }
        if (this.propertyId != null) {
            this.getProject().setProperty(this.propertyId, manifestInfo.getId());
        }
        if (this.propertyVersion != null) {
            version = manifestInfo.getVersion();
            this.getProject().setProperty(this.propertyVersion, version != null ? version.toString() : "");
        }
        if (this.propertyVendor != null) {
            value = manifestInfo.getVendor();
            this.getProject().setProperty(this.propertyVendor, (String)(value != null ? value : ""));
        }
        if (this.propertyPluginId != null) {
            value = manifestInfo.getPluginId();
            this.getProject().setProperty(this.propertyPluginId, (String)(value != null ? value : ""));
        }
        if (this.propertyPluginVersion != null) {
            version = manifestInfo.getPluginVersion();
            this.getProject().setProperty(this.propertyPluginVersion, version != null ? version.toString() : "");
        }
        if (this.propertyMatchingRule != null) {
            value = manifestInfo.getMatchingRule();
            this.getProject().setProperty(this.propertyMatchingRule, value != null ? ((MatchingRule)((Object)value)).toCode() : "");
        }
    }
}

