/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import java.util.Random;
import jdd.util.Test;
import jdd.util.math.Chi2Test;

public class FastRandom {
    private static final int MT_N = 624;
    private static final int MT_M = 397;
    private static final int MT_A = -1727480561;
    private static final int MT_B = -1658038656;
    private static final int MT_C = -272236544;
    private static final int MT_MAKS_UPPER = Integer.MIN_VALUE;
    private static final int MT_MASK_LOWER = Integer.MAX_VALUE;
    private static int[] mt_mt = new int[624];
    private static int[] mt_mag01 = new int[2];
    private static int mt_mti;

    private static final int MT_SHIFT_U(int n) {
        return n >>> 11;
    }

    private static final int MT_SHIFT_S(int n) {
        return n << 7;
    }

    private static final int MT_SHIFT_T(int n) {
        return n << 15;
    }

    private static final int MT_SHIFT_L(int n) {
        return n >>> 18;
    }

    public static final void mtseed(int n) {
        FastRandom.mt_mt[0] = n;
        for (mt_mti = 1; mt_mti < 624; ++mt_mti) {
            FastRandom.mt_mt[FastRandom.mt_mti] = 1812433253 * (mt_mt[mt_mti - 1] ^ mt_mt[mt_mti - 1] >>> 30) + mt_mti;
        }
    }

    public static final int mtrand() {
        int n;
        if (mt_mti >= 624) {
            int n2;
            FastRandom.mt_mag01[0] = 0;
            FastRandom.mt_mag01[1] = -1727480561;
            for (n2 = 0; n2 < 227; ++n2) {
                n = mt_mt[n2] & Integer.MIN_VALUE | mt_mt[n2 + 1] & Integer.MAX_VALUE;
                FastRandom.mt_mt[n2] = mt_mt[n2 + 397] ^ n >>> 1 ^ mt_mag01[n & 1];
            }
            while (n2 < 623) {
                n = mt_mt[n2] & Integer.MIN_VALUE | mt_mt[n2 + 1] & Integer.MAX_VALUE;
                FastRandom.mt_mt[n2] = mt_mt[n2 + -227] ^ n >>> 1 ^ mt_mag01[n & 1];
                ++n2;
            }
            n = mt_mt[623] & Integer.MIN_VALUE | mt_mt[0] & Integer.MAX_VALUE;
            FastRandom.mt_mt[623] = mt_mt[396] ^ n >>> 1 ^ mt_mag01[n & 1];
            mt_mti = 0;
        }
        n = mt_mt[mt_mti++];
        n ^= FastRandom.MT_SHIFT_U(n);
        n ^= FastRandom.MT_SHIFT_S(n) & 0x9D2C5680;
        n ^= FastRandom.MT_SHIFT_T(n) & 0xEFC60000;
        n ^= FastRandom.MT_SHIFT_L(n);
        return n & Integer.MAX_VALUE;
    }

    public static void internal_test() {
        Test.start("FastRandom");
        Random random = new Random();
        Chi2Test chi2Test = new Chi2Test(1000);
        Chi2Test chi2Test2 = new Chi2Test(1000);
        while (chi2Test.more()) {
            chi2Test.add(FastRandom.mtrand() % 1000);
            chi2Test2.add(random.nextInt(1000));
        }
        Test.check(chi2Test.isStandardDeviationAcceptable(), "Mersenne Twister PRNG working ok");
        Test.check(chi2Test2.isStandardDeviationAcceptable(), "Java PRNG working ok");
        Test.end();
    }

    static {
        FastRandom.mtseed((int)(1.0 + 2.147483646E9 * Math.random()));
    }
}

