/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.datastructure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MruList
implements Set {
    private HashMap _entryMap = new HashMap();
    private long _lastCleanupTime;
    private TreeSet _mruList = new TreeSet();
    private long _sizeLimit;
    private long _timeout;

    public MruList() {
        this(0L, 0L);
    }

    public MruList(long sizeLimit, long timeout) {
        this._sizeLimit = sizeLimit;
        this._timeout = timeout;
        this._lastCleanupTime = System.currentTimeMillis();
    }

    public boolean access(Object o) {
        long now = System.currentTimeMillis();
        if (this._timeout > 0L && now - this._lastCleanupTime > this._timeout) {
            this.expireEntries(this._timeout);
        }
        boolean flag = false;
        MruEntry entry = (MruEntry)this._entryMap.get(o);
        if (entry != null) {
            this._mruList.remove(entry);
            entry._lastAccessTime = now;
            flag = true;
        } else {
            entry = new MruEntry(o, now);
            this._entryMap.put(o, entry);
        }
        this._mruList.add(entry);
        if (this._sizeLimit > 0L && (long)this.size() > this._sizeLimit) {
            this.truncateEntries(this._sizeLimit);
        }
        return flag;
    }

    public boolean add(Object o) {
        return this.access(o);
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public void clear() {
        this._entryMap.clear();
        this._mruList.clear();
    }

    public boolean contains(Object o) {
        return this._entryMap.containsKey(o);
    }

    public boolean containsAll(Collection c) {
        return this._entryMap.keySet().containsAll(c);
    }

    public void expireEntries(long t) {
        MruEntry entry;
        long now;
        this._lastCleanupTime = now = System.currentTimeMillis();
        while ((entry = (MruEntry)this._mruList.last()) != null && now - entry._lastAccessTime > t) {
            this.expireEntry(entry._obj);
        }
    }

    public long getLastAccessTime(Object obj) {
        MruEntry entry = (MruEntry)this._entryMap.get(obj);
        if (entry != null) {
            return entry._lastAccessTime;
        }
        return -1L;
    }

    public boolean isEmpty() {
        return this._entryMap.size() == 0;
    }

    public Iterator iterator() {
        return new MruIterator(this._mruList.iterator());
    }

    public boolean remove(Object o) {
        MruEntry entry = (MruEntry)this._entryMap.remove(o);
        boolean flag = false;
        if (entry != null) {
            this._mruList.remove(entry);
            flag = true;
        }
        return flag;
    }

    public boolean removeAll(Collection c) {
        boolean flag = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            flag = true;
        }
        return flag;
    }

    public boolean retainAll(Collection c) {
        Iterator it = this._entryMap.keySet().iterator();
        boolean flag = false;
        while (it.hasNext()) {
            Object obj = it.next();
            if (c.contains(obj)) continue;
            this.remove(obj);
            flag = true;
        }
        return flag;
    }

    public int size() {
        return this._entryMap.size();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void truncateEntries(long size) {
        while ((long)this.size() > size) {
            MruEntry entry = (MruEntry)this._mruList.last();
            this.truncateEntry(entry._obj);
        }
    }

    protected void truncateEntry(Object obj) {
        this.remove(obj);
    }

    protected void expireEntry(Object obj) {
        this.remove(obj);
    }

    protected static class MruIterator
    implements Iterator {
        private Iterator _entryIterator;

        public MruIterator(Iterator entryIterator) {
            this._entryIterator = entryIterator;
        }

        public boolean hasNext() {
            return this._entryIterator.hasNext();
        }

        public Object next() {
            MruEntry entry = (MruEntry)this._entryIterator.next();
            return entry._obj;
        }

        public void remove() {
            this._entryIterator.remove();
        }
    }

    protected static class MruEntry
    implements Comparable {
        private long _lastAccessTime;
        private Object _obj;

        public MruEntry(Object obj, long time) {
            this._obj = obj;
            this._lastAccessTime = time;
        }

        public int compareTo(MruEntry e) {
            if (this._lastAccessTime > e._lastAccessTime) {
                return -1;
            }
            if (this._lastAccessTime < e._lastAccessTime) {
                return 1;
            }
            if (this._obj.equals(e._obj)) {
                return 0;
            }
            if (this._obj.hashCode() > e._obj.hashCode()) {
                return 1;
            }
            return -1;
        }

        public int compareTo(Object o) {
            return this.compareTo((MruEntry)o);
        }

        public final long getLastAccessTime() {
            return this._lastAccessTime;
        }

        public final void setLastAccessTime(long lastAccessTime) {
            this._lastAccessTime = lastAccessTime;
        }

        public final Object getObj() {
            return this._obj;
        }

        public final void setObj(Object obj) {
            this._obj = obj;
        }

        public String toString() {
            return this._obj + ": " + this._lastAccessTime;
        }
    }
}

