/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.ImplicitCachedStatesAutomaton;
import owl.automaton.ImplicitNonDeterministicLabelledEdgesAutomaton;
import owl.automaton.ImplicitSemiDeterministicEdgesAutomaton;
import owl.automaton.LabelledEdgesAutomatonMixin;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.factories.ValuationSetFactory;

public final class AutomatonFactory {
    private AutomatonFactory() {
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, BiFunction<S, BitSet, Edge<S>> transitions) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, transitions);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, BiFunction<S, BitSet, Edge<S>> transitions) {
        return new ImplicitSemiDeterministicEdgesAutomaton<S, A>(factory, initialStates, acceptance, transitions);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, BiFunction<S, BitSet, ? extends Collection<Edge<S>>> edgesFunction, Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, edgesFunction, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction) {
        return new ImplicitNonDeterministicLabelledEdgesAutomaton<S, A>(factory, initialStates, acceptance, null, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, BiFunction<S, BitSet, ? extends Collection<Edge<S>>> edgesFunction, Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction) {
        return new ImplicitNonDeterministicLabelledEdgesAutomaton<S, A>(factory, initialStates, acceptance, Objects.requireNonNull(edgesFunction), labelledEdgesFunction);
    }

    public static <S> Automaton<S, NoneAcceptance> empty(ValuationSetFactory factory) {
        return new EmptyAutomaton(factory);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance) {
        return new SingletonAutomaton(state, factory, null, acceptance, null);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance, Set<Integer> acceptanceSet) {
        return new SingletonAutomaton(state, factory, BitSets.of(acceptanceSet), acceptance, null);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance, BitSet acceptanceSet) {
        return new SingletonAutomaton(state, factory, acceptanceSet, acceptance, null);
    }

    private static final class SingletonAutomaton<S, A extends OmegaAcceptance>
    extends ImplicitCachedStatesAutomaton<S, A>
    implements LabelledEdgesAutomatonMixin<S, A> {
        private final List<LabelledEdge<S>> selfLoopEdges;

        private SingletonAutomaton(S singletonState, ValuationSetFactory factory, @Nullable BitSet acceptanceSets, A acceptance) {
            super(factory, Set.of(singletonState), acceptance);
            this.selfLoopEdges = acceptanceSets == null ? List.of() : List.of(LabelledEdge.of(singletonState, acceptanceSets, factory.universe()));
        }

        @Override
        public List<LabelledEdge<S>> labelledEdges(S state) {
            Preconditions.checkArgument((boolean)this.initialStates.contains(state), (Object)"This state is not in the automaton");
            return this.selfLoopEdges;
        }

        /* synthetic */ SingletonAutomaton(Object x0, ValuationSetFactory x1, BitSet x2, OmegaAcceptance x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    private static final class EmptyAutomaton<S>
    extends ImplicitCachedStatesAutomaton<S, NoneAcceptance>
    implements LabelledEdgesAutomatonMixin<S, NoneAcceptance> {
        private EmptyAutomaton(ValuationSetFactory factory) {
            super(factory, Set.of(), NoneAcceptance.INSTANCE);
        }

        @Override
        public List<LabelledEdge<S>> labelledEdges(S state) {
            throw new IllegalArgumentException("There are no states in this automaton.");
        }
    }
}

