/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.HOAFParserSettings;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import jhoafparser.transformations.ToTransitionAcceptance;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.collections.ValuationSetUtil;
import owl.factories.FactorySupplier;
import owl.factories.ValuationSetFactory;

public final class AutomatonReader {
    private AutomatonReader() {
    }

    public static HOAConsumerStore getConsumer(Consumer<? super Automaton<HoaState, ?>> consumer, FactorySupplier factory) {
        return new HoaConsumerAutomatonSupplier(consumer, factory);
    }

    public static HOAConsumerStore getConsumer(Consumer<? super Automaton<HoaState, ?>> consumer, ValuationSetFactory factory) {
        return new HoaConsumerAutomatonFactory(consumer, factory);
    }

    public static void readHoa(InputStream stream, Consumer<Automaton<HoaState, ?>> consumer, FactorySupplier factorySupplier) throws ParseException {
        HOAFParserSettings settings = new HOAFParserSettings();
        HOAFParser.parseHOA((InputStream)stream, () -> new ToTransitionAcceptance((HOAConsumer)AutomatonReader.getConsumer(consumer, factorySupplier)), (HOAFParserSettings)settings);
    }

    public static void readHoa(InputStream stream, Consumer<Automaton<HoaState, ?>> consumer, ValuationSetFactory vsFactory) throws ParseException {
        HOAFParserSettings settings = new HOAFParserSettings();
        HOAFParser.parseHOA((InputStream)stream, () -> new ToTransitionAcceptance((HOAConsumer)AutomatonReader.getConsumer(consumer, vsFactory)), (HOAFParserSettings)settings);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(String input, FactorySupplier factorySupplier, Class<A> acceptanceClass) throws ParseException {
        return AutomatonReader.readHoa(AutomatonReader.toStream(input), factorySupplier, acceptanceClass);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(String input, ValuationSetFactory vsFactory, Class<A> acceptanceClass) throws ParseException {
        return AutomatonReader.readHoa(AutomatonReader.toStream(input), vsFactory, acceptanceClass);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(InputStream stream, FactorySupplier factorySupplier, Class<A> acceptanceClass) throws ParseException {
        ArrayList automata = new ArrayList();
        Consumer<Automaton<HoaState, ?>> automatonConsumer = automaton -> automata.add(AutomatonUtil.cast(automaton, HoaState.class, acceptanceClass));
        AutomatonReader.readHoa(stream, automatonConsumer, factorySupplier);
        return (Automaton)Iterables.getOnlyElement(automata);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(InputStream stream, ValuationSetFactory vsFactory, Class<A> acceptanceClass) throws ParseException {
        ArrayList automata = new ArrayList();
        Consumer<Automaton<HoaState, ?>> automatonConsumer = automaton -> automata.add(AutomatonUtil.cast(automaton, HoaState.class, acceptanceClass));
        AutomatonReader.readHoa(stream, automatonConsumer, vsFactory);
        return (Automaton)Iterables.getOnlyElement(automata);
    }

    public static List<Automaton<HoaState, ?>> readHoaCollection(InputStream input, FactorySupplier factorySupplier) throws ParseException {
        ArrayList automatonList = new ArrayList();
        AutomatonReader.readHoa(input, automatonList::add, factorySupplier);
        return automatonList;
    }

    public static List<Automaton<HoaState, ?>> readHoaCollection(String input, FactorySupplier factorySupplier) throws ParseException {
        return AutomatonReader.readHoaCollection(AutomatonReader.toStream(input), factorySupplier);
    }

    private static InputStream toStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    private static final class StoredConverter {
        private final MutableAutomaton<HoaState, ?> automaton;
        @Nullable
        private final int[] remapping;
        private final Int2ObjectMap<HoaState> states;
        private final StoredAutomaton storedAutomaton;
        private final StoredHeader storedHeader;
        private final ValuationSetFactory vsFactory;

        StoredConverter(StoredAutomaton storedAutomaton, ValuationSetFactory vsFactory) throws HOAConsumerException {
            StoredConverter.check(!storedAutomaton.hasUniversalBranching(), "Universal branching not supported");
            this.storedAutomaton = storedAutomaton;
            this.storedHeader = storedAutomaton.getStoredHeader();
            List variables = this.storedHeader.getAPs();
            List<String> alphabet = vsFactory.alphabet();
            if (variables.equals(alphabet)) {
                this.remapping = null;
            } else {
                this.remapping = new int[variables.size()];
                ListIterator variableIterator = variables.listIterator();
                while (variableIterator.hasNext()) {
                    int variableIndex = alphabet.indexOf(variableIterator.next());
                    Preconditions.checkArgument((variableIndex >= 0 ? 1 : 0) != 0);
                    this.remapping[variableIterator.previousIndex()] = variableIndex;
                }
            }
            OmegaAcceptance acceptance = this.getAcceptance();
            this.vsFactory = vsFactory;
            this.automaton = new HashMapAutomaton<HoaState, OmegaAcceptance>(this.vsFactory, acceptance);
            String name = storedAutomaton.getStoredHeader().getName();
            if (name != null) {
                this.automaton.name(name);
            }
            this.states = new Int2ObjectLinkedOpenHashMap(storedAutomaton.getNumberOfStates());
        }

        StoredConverter(StoredAutomaton storedAutomaton, FactorySupplier factorySupplier) throws HOAConsumerException {
            this(storedAutomaton, factorySupplier.getValuationSetFactory(storedAutomaton.getStoredHeader().getAPs()));
        }

        static void check(boolean condition) throws HOAConsumerException {
            StoredConverter.check(condition, "", null);
        }

        static void check(boolean condition, String message) throws HOAConsumerException {
            StoredConverter.check(condition, message, null);
        }

        static void check(boolean condition, String formatString, Object ... args) throws HOAConsumerException {
            if (!condition) {
                String message = Strings.isNullOrEmpty((String)formatString) || args == null || args.length == 0 ? "" : String.format(formatString, args);
                throw new HOAConsumerException(message);
            }
        }

        private void addEdge(HoaState source, ValuationSet valuationSet, @Nullable List<Integer> storedEdgeAcceptance, HoaState successor) throws HOAConsumerException {
            Edge<HoaState> edge = storedEdgeAcceptance == null ? Edge.of(successor) : Edge.of(successor, BitSets.of(storedEdgeAcceptance));
            StoredConverter.check(((OmegaAcceptance)this.automaton.acceptance()).isWellFormedEdge(edge));
            this.automaton.addEdge(source, valuationSet, edge);
        }

        private OmegaAcceptance getAcceptance() throws HOAConsumerException {
            BooleanExpression acceptanceExpression = this.storedHeader.getAcceptanceCondition();
            int numberOfAcceptanceSets = this.storedHeader.getNumberOfAcceptanceSets();
            List acceptanceNames = this.storedHeader.getAcceptanceNames();
            Preconditions.checkState((acceptanceNames.size() == 1 ? 1 : 0) != 0);
            StoredHeader.NameAndExtra acceptanceDescription = (StoredHeader.NameAndExtra)acceptanceNames.get(0);
            List acceptanceExtra = (List)acceptanceDescription.extra;
            switch (acceptanceDescription.name.toLowerCase(Locale.ENGLISH)) {
                case "all": {
                    return AllAcceptance.INSTANCE;
                }
                case "none": {
                    return NoneAcceptance.INSTANCE;
                }
                case "buchi": {
                    return BuchiAcceptance.INSTANCE;
                }
                case "parity": {
                    int colours;
                    boolean even;
                    String stringParity;
                    boolean max;
                    String stringPriority;
                    StoredConverter.check(acceptanceExtra.size() == 3);
                    switch (stringPriority = acceptanceExtra.get(0).toString()) {
                        case "max": {
                            max = true;
                            break;
                        }
                        case "min": {
                            max = false;
                            break;
                        }
                        default: {
                            throw new HOAConsumerException("Unknown priority " + stringPriority);
                        }
                    }
                    switch (stringParity = acceptanceExtra.get(1).toString()) {
                        case "even": {
                            even = true;
                            break;
                        }
                        case "odd": {
                            even = false;
                            break;
                        }
                        default: {
                            throw new HOAConsumerException("Unknown parity " + stringParity);
                        }
                    }
                    String stringColours = acceptanceExtra.get(2).toString();
                    try {
                        colours = Integer.valueOf(stringColours);
                    }
                    catch (NumberFormatException e) {
                        throw (HOAConsumerException)new HOAConsumerException("Failed to parse colours " + stringColours).initCause((Throwable)e);
                    }
                    StoredConverter.check(colours >= 0, "Negative colours");
                    StoredConverter.check(colours == numberOfAcceptanceSets, "Mismatch between colours (%d) and acceptance set count (%d)", colours, numberOfAcceptanceSets);
                    return new ParityAcceptance(numberOfAcceptanceSets, ParityAcceptance.Parity.of(max, even));
                }
                case "co-buchi": {
                    return CoBuchiAcceptance.INSTANCE;
                }
                case "generalized-buchi": {
                    int sets = Integer.parseInt(acceptanceExtra.get(0).toString());
                    return GeneralizedBuchiAcceptance.of(sets);
                }
                case "generalized-co-buchi": {
                    return new EmersonLeiAcceptance(numberOfAcceptanceSets, (BooleanExpression<AtomAcceptance>)acceptanceExpression);
                }
                case "streett": {
                    return new EmersonLeiAcceptance(numberOfAcceptanceSets, (BooleanExpression<AtomAcceptance>)acceptanceExpression);
                }
                case "rabin": {
                    return RabinAcceptance.of((BooleanExpression<AtomAcceptance>)acceptanceExpression);
                }
                case "generalized-rabin": {
                    return GeneralizedRabinAcceptance.of((BooleanExpression<AtomAcceptance>)acceptanceExpression);
                }
            }
            return new EmersonLeiAcceptance(numberOfAcceptanceSets, (BooleanExpression<AtomAcceptance>)acceptanceExpression);
        }

        private HoaState getSuccessor(List<Integer> successors) throws HOAConsumerException {
            StoredConverter.check(successors.size() == 1, "Universal edges not supported");
            return (HoaState)this.states.get(((Integer)Iterables.getOnlyElement(successors)).intValue());
        }

        MutableAutomaton<HoaState, ?> transform() throws HOAConsumerException {
            HoaState state;
            int stateId;
            for (StoredState storedState : this.storedAutomaton.getStoredStates()) {
                stateId = storedState.getStateId();
                state = new HoaState(stateId, storedState.getInfo());
                assert (!this.states.containsKey(stateId));
                this.states.put(stateId, (Object)state);
            }
            for (List startState : this.storedHeader.getStartStates()) {
                StoredConverter.check(startState.size() == 1, "Universal initial states not supported");
                this.automaton.addInitialState((HoaState)this.states.get(((Integer)Iterables.getOnlyElement((Iterable)startState)).intValue()));
            }
            for (StoredState storedState : this.storedAutomaton.getStoredStates()) {
                stateId = storedState.getStateId();
                state = (HoaState)this.states.get(stateId);
                this.automaton.addState(state);
                assert (storedState.getAccSignature() == null || storedState.getAccSignature().isEmpty());
                if (this.storedAutomaton.hasEdgesImplicit(stateId)) {
                    assert (!this.storedAutomaton.hasEdgesWithLabel(stateId));
                    Iterable edgesImplicit = this.storedAutomaton.getEdgesImplicit(stateId);
                    assert (edgesImplicit != null);
                    long counter = 0L;
                    for (StoredEdgeImplicit implicitEdge : edgesImplicit) {
                        StoredConverter.check(counter < 1L << this.storedHeader.getAPs().size());
                        HoaState successorState = this.getSuccessor(implicitEdge.getConjSuccessors());
                        ValuationSet valuationSet = this.vsFactory.of(BooleanExpression.fromImplicit((long)counter));
                        List edgeAcceptance = implicitEdge.getAccSignature();
                        this.addEdge(state, valuationSet, edgeAcceptance, successorState);
                        ++counter;
                    }
                    StoredConverter.check(counter == 1L << this.storedHeader.getAPs().size());
                    continue;
                }
                if (!this.storedAutomaton.hasEdgesWithLabel(stateId)) continue;
                IntUnaryOperator apMapping = this.remapping == null ? null : i -> this.remapping[i];
                for (StoredEdgeWithLabel edgeWithLabel : this.storedAutomaton.getEdgesWithLabel(stateId)) {
                    HoaState successorState = this.getSuccessor(edgeWithLabel.getConjSuccessors());
                    ValuationSet valuationSet = ValuationSetUtil.toValuationSet(this.vsFactory, (BooleanExpression<AtomLabel>)edgeWithLabel.getLabelExpr(), apMapping);
                    this.addEdge(state, valuationSet, edgeWithLabel.getAccSignature(), successorState);
                }
            }
            this.automaton.trim();
            return this.automaton;
        }
    }

    public static final class HoaState {
        final int id;
        @Nullable
        final String info;

        HoaState(int id, @Nullable String info) {
            this.id = id;
            this.info = info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HoaState)) {
                return false;
            }
            HoaState that = (HoaState)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.id);
        }

        public String toString() {
            return this.info == null ? Integer.toString(this.id) : String.format("%d (%s)", this.id, this.info);
        }
    }

    private static final class HoaConsumerAutomatonSupplier
    extends HOAConsumerStore {
        private final Consumer<? super Automaton<HoaState, ?>> consumer;
        private final FactorySupplier factory;

        HoaConsumerAutomatonSupplier(Consumer<? super Automaton<HoaState, ?>> consumer, FactorySupplier factory) {
            this.consumer = consumer;
            this.factory = factory;
        }

        public void notifyEnd() throws HOAConsumerException {
            super.notifyEnd();
            this.consumer.accept(new StoredConverter(this.getStoredAutomaton(), this.factory).transform());
        }
    }

    private static final class HoaConsumerAutomatonFactory
    extends HOAConsumerStore {
        private final Consumer<? super Automaton<HoaState, ?>> consumer;
        private final ValuationSetFactory vsFactory;

        HoaConsumerAutomatonFactory(Consumer<? super Automaton<HoaState, ?>> consumer, ValuationSetFactory vsFactory) {
            this.consumer = consumer;
            this.vsFactory = vsFactory;
        }

        public void notifyEnd() throws HOAConsumerException {
            super.notifyEnd();
            this.consumer.accept(new StoredConverter(this.getStoredAutomaton(), this.vsFactory).transform());
        }
    }
}

