/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.AbstractAutomaton;
import owl.automaton.Automaton;
import owl.automaton.DefaultImplementations;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.factories.ValuationSetFactory;

public abstract class ImplicitCachedStatesAutomaton<S, A extends OmegaAcceptance>
extends AbstractAutomaton<S, A> {
    @Nullable
    private Set<S> statesCache;

    public ImplicitCachedStatesAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
        super(factory, acceptance, initialStates);
    }

    @Override
    public final Set<S> states() {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.getReachableStates(this));
        }
        return this.statesCache;
    }

    @Override
    public final void accept(Automaton.EdgeVisitor<S> visitor) {
        Set<S> exploredStates = DefaultImplementations.visit(this, visitor);
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(exploredStates);
        }
    }

    @Override
    public final void accept(Automaton.LabelledEdgeVisitor<S> visitor) {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.visit(this, visitor));
        } else {
            for (S state : this.statesCache) {
                visitor.enter(state);
                this.forEachLabelledEdge(state, visitor::visitLabelledEdge);
                visitor.exit(state);
            }
        }
    }

    @Nullable
    protected final Set<S> cache() {
        return this.statesCache;
    }
}

