/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class MutableAutomatonFactory {
    private MutableAutomatonFactory() {
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> copy(Automaton<S, A> source) {
        HashMapAutomaton target = new HashMapAutomaton(source.factory(), source.acceptance());
        MutableAutomatonFactory.copy(source, target);
        assert (source.states().equals(target.states()));
        return target;
    }

    public static <S> void copy(Automaton<S, ?> source, MutableAutomaton<S, ?> target) {
        source.initialStates().forEach(target::addInitialState);
        source.accept(new CopyVisitor(target));
        target.trim();
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> create(A acceptance, ValuationSetFactory vsFactory) {
        return new HashMapAutomaton(vsFactory, acceptance);
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> create(A acceptance, ValuationSetFactory vsFactory, Collection<S> initialStates, BiFunction<S, BitSet, Edge<S>> successors, Function<S, BitSet> alphabet) {
        HashMapAutomaton automaton = new HashMapAutomaton(vsFactory, acceptance);
        initialStates.forEach(automaton::addInitialState);
        HashSet<S> exploredStates = new HashSet<S>(initialStates);
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        int alphabetSize = vsFactory.alphabetSize();
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            BitSet sensitiveAlphabet = alphabet.apply(state);
            Set bitSets = sensitiveAlphabet == null ? BitSets.powerSet((int)alphabetSize) : BitSets.powerSet((BitSet)sensitiveAlphabet);
            for (BitSet valuation : bitSets) {
                Edge<S> edge = successors.apply(state, valuation);
                if (edge == null) continue;
                ValuationSet valuationSet = sensitiveAlphabet == null ? vsFactory.of(valuation) : vsFactory.of(valuation, sensitiveAlphabet);
                S successorState = edge.successor();
                if (exploredStates.add(successorState)) {
                    workQueue.add(successorState);
                }
                automaton.addEdge(state, valuationSet, edge);
            }
        }
        return automaton;
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> create(A acceptance, ValuationSetFactory vsFactory, Collection<S> initialStates, BiFunction<S, BitSet, ? extends Collection<Edge<S>>> successors) {
        HashMapAutomaton<Object, A> automaton = new HashMapAutomaton<Object, A>(vsFactory, acceptance);
        automaton.initialStates(initialStates);
        int alphabetSize = automaton.factory().alphabetSize();
        HashSet<S> exploredStates = new HashSet<S>(initialStates);
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            for (BitSet valuation : BitSets.powerSet((int)alphabetSize)) {
                for (Edge<S> edge : successors.apply(state, valuation)) {
                    ValuationSet valuationSet = automaton.factory().of(valuation);
                    S successorState = edge.successor();
                    if (exploredStates.add(successorState)) {
                        workQueue.add(successorState);
                    }
                    automaton.addEdge(state, valuationSet, edge);
                }
            }
        }
        automaton.trim();
        return automaton;
    }

    private static class CopyVisitor<S>
    implements Automaton.HybridVisitor<S> {
        @Nullable
        private S currentState = null;
        private final MutableAutomaton<S, ?> target;

        private CopyVisitor(MutableAutomaton<S, ?> target) {
            this.target = target;
        }

        @Override
        public void visitEdge(Edge<S> edge, BitSet valuation) {
            assert (this.currentState != null);
            this.target.addEdge(this.currentState, valuation, edge);
        }

        @Override
        public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
            assert (this.currentState != null);
            this.target.addEdge(this.currentState, valuationSet, edge);
        }

        @Override
        public void enter(S state) {
            this.currentState = state;
            this.target.addState(state);
        }

        @Override
        public void exit(S state) {
            this.currentState = null;
        }
    }
}

