/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.automaton.acceptance.BooleanExpressions;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;

public final class ParityAcceptance
extends OmegaAcceptance {
    @Nonnegative
    private final int colours;
    private final Parity parity;

    public ParityAcceptance(@Nonnegative int colours, Parity parity) {
        this.colours = colours;
        this.parity = parity;
    }

    @Override
    public String name() {
        return "parity";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(this.parity.maxString(), this.parity.evenString(), Integer.valueOf(this.colours));
    }

    @Override
    public BitSet acceptingSet() {
        BitSet set = new BitSet();
        if (this.parity.even()) {
            set.set(0);
        } else {
            set.set(1);
        }
        if (this.colours < set.length()) {
            throw new NoSuchElementException();
        }
        return set;
    }

    @Override
    public BitSet rejectingSet() {
        BitSet set = new BitSet();
        if (this.parity.even()) {
            set.set(1);
        } else {
            set.set(0);
        }
        if (this.colours < set.length()) {
            throw new NoSuchElementException();
        }
        return set;
    }

    public Parity parity() {
        return this.parity;
    }

    public ParityAcceptance withParity(Parity parity) {
        return new ParityAcceptance(this.colours, parity);
    }

    public ParityAcceptance complement() {
        return new ParityAcceptance(this.colours, this.parity.flipEven());
    }

    public boolean emptyIsAccepting() {
        return this.parity == Parity.MIN_EVEN || this.parity == Parity.MAX_ODD;
    }

    @Override
    public int acceptanceSets() {
        return this.colours;
    }

    @Override
    public BooleanExpression<AtomAcceptance> booleanExpression() {
        BooleanExpression exp;
        if (this.colours == 0) {
            return new BooleanExpression(this.emptyIsAccepting());
        }
        if (this.parity.max()) {
            exp = this.mkColor(0);
            for (int i = 1; i < this.colours; ++i) {
                exp = this.isAccepting(i) ? this.mkColor(i).or(exp) : this.mkColor(i).and(exp);
            }
        } else {
            exp = this.mkColor(this.colours - 1);
            for (int i = this.colours - 2; i >= 0; --i) {
                exp = this.isAccepting(i) ? this.mkColor(i).or(exp) : this.mkColor(i).and(exp);
            }
        }
        return exp;
    }

    private BooleanExpression<AtomAcceptance> mkColor(int priority) {
        return this.isAccepting(priority) ? BooleanExpressions.mkInf(priority) : BooleanExpressions.mkFin(priority);
    }

    public boolean isAccepting(int priority) {
        return priority % 2 == 0 ^ !this.parity.even();
    }

    @Override
    public boolean isWellFormedEdge(Edge<?> edge) {
        return !edge.hasAcceptanceSets() || edge.smallestAcceptanceSet() == edge.largestAcceptanceSet() && edge.largestAcceptanceSet() < this.colours;
    }

    public ParityAcceptance withAcceptanceSets(@Nonnegative int colours) {
        return new ParityAcceptance(colours, this.parity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParityAcceptance that = (ParityAcceptance)o;
        return this.colours == that.colours && this.parity == that.parity;
    }

    public int hashCode() {
        return HashCommon.mix((int)this.colours) ^ this.parity.hashCode();
    }

    public static enum Parity {
        MIN_EVEN,
        MIN_ODD,
        MAX_EVEN,
        MAX_ODD;


        public static Parity of(boolean max, boolean even) {
            if (max && even) {
                return MAX_EVEN;
            }
            if (max) {
                return MAX_ODD;
            }
            if (even) {
                return MIN_EVEN;
            }
            return MIN_ODD;
        }

        public Parity flipMax() {
            switch (this) {
                case MIN_ODD: {
                    return MAX_ODD;
                }
                case MIN_EVEN: {
                    return MAX_EVEN;
                }
                case MAX_EVEN: {
                    return MIN_EVEN;
                }
                case MAX_ODD: {
                    return MIN_ODD;
                }
            }
            throw new AssertionError();
        }

        public Parity flipEven() {
            switch (this) {
                case MIN_ODD: {
                    return MIN_EVEN;
                }
                case MIN_EVEN: {
                    return MIN_ODD;
                }
                case MAX_EVEN: {
                    return MAX_ODD;
                }
                case MAX_ODD: {
                    return MAX_EVEN;
                }
            }
            throw new AssertionError();
        }

        public boolean even() {
            return this.equals((Object)MIN_EVEN) || this.equals((Object)MAX_EVEN);
        }

        public boolean max() {
            return this.equals((Object)MAX_EVEN) || this.equals((Object)MAX_ODD);
        }

        public Parity setEven(boolean even) {
            return even == this.even() ? this : this.flipEven();
        }

        public Parity setMax(boolean max) {
            return max == this.max() ? this : this.flipMax();
        }

        public String evenString() {
            return this.even() ? "even" : "odd";
        }

        public String maxString() {
            return this.max() ? "max" : "min";
        }

        public String toString() {
            return this.maxString() + " " + this.evenString();
        }
    }
}

