/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.minimizations;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.minimizations.MinimizationUtil;
import owl.run.PipelineExecutionContext;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;

public class ImplicitMinimizeTransformer
extends Transformers.SimpleTransformer {
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("minimize-aut").description("Tries to minimize the given automaton").optionsDirect(new Options().addOption("l", "level", true, "Level of minimization (light,medium,all)")).parser(settings -> {
        String levelString = settings.getOptionValue("level");
        MinimizationUtil.MinimizationLevel level = ImplicitMinimizeTransformer.getLevel(levelString);
        if (level == null) {
            throw new ParseException("Invalid value for \"level\": " + levelString);
        }
        return environment -> new ImplicitMinimizeTransformer(level);
    }).build();
    private final MinimizationUtil.MinimizationLevel level;

    public ImplicitMinimizeTransformer() {
        this(MinimizationUtil.MinimizationLevel.ALL);
    }

    public ImplicitMinimizeTransformer(MinimizationUtil.MinimizationLevel level) {
        this.level = level;
    }

    @Nullable
    private static MinimizationUtil.MinimizationLevel getLevel(@Nullable String string) {
        if (string == null) {
            return MinimizationUtil.MinimizationLevel.ALL;
        }
        switch (string) {
            case "light": {
                return MinimizationUtil.MinimizationLevel.LIGHT;
            }
            case "medium": {
                return MinimizationUtil.MinimizationLevel.MEDIUM;
            }
            case "all": {
                return MinimizationUtil.MinimizationLevel.ALL;
            }
        }
        return null;
    }

    @Override
    public Object transform(Object object, PipelineExecutionContext context) {
        Preconditions.checkArgument((boolean)(object instanceof Automaton), (String)"Expected automaton, got %s", object.getClass());
        MutableAutomaton automaton = MutableAutomatonUtil.asMutable((Automaton)object);
        MinimizationUtil.minimizeDefault(automaton, this.level);
        automaton.trim();
        return automaton;
    }
}

