/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.output;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.EnumSet;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerPrint;
import owl.automaton.Automaton;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.output.HoaConsumerExtended;
import owl.collections.ValuationSet;
import owl.util.TypeUtil;

public final class HoaPrinter {
    private HoaPrinter() {
    }

    public static <S> String toString(Automaton<S, ?> automaton) {
        return HoaPrinter.toString(automaton, EnumSet.of(HoaOption.ANNOTATIONS));
    }

    public static <S> String toString(Automaton<S, ?> automaton, EnumSet<HoaOption> options) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        HoaPrinter.feedTo(automaton, (HOAConsumer)new HOAConsumerPrint((OutputStream)writer), options);
        return new String(writer.toByteArray(), StandardCharsets.UTF_8);
    }

    public static <S> String toString(LimitDeterministicAutomaton<S, ?, ?, ?> automaton) {
        return HoaPrinter.toString(automaton, EnumSet.of(HoaOption.ANNOTATIONS));
    }

    public static <S> String toString(LimitDeterministicAutomaton<S, ?, ?, ?> automaton, EnumSet<HoaOption> options) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        HoaPrinter.feedTo(automaton, (HOAConsumer)new HOAConsumerPrint((OutputStream)writer), options);
        return new String(writer.toByteArray(), StandardCharsets.UTF_8);
    }

    public static void feedTo(Object automaton, HOAConsumer consumer) {
        HoaPrinter.feedTo(automaton, consumer, EnumSet.noneOf(HoaOption.class));
    }

    public static void feedTo(Object automaton, HOAConsumer consumer, EnumSet<HoaOption> options) {
        Preconditions.checkArgument((automaton instanceof Automaton || automaton instanceof LimitDeterministicAutomaton ? 1 : 0) != 0);
        if (automaton instanceof Automaton) {
            HoaPrinter.feedTo((Automaton)automaton, consumer, options);
        } else {
            HoaPrinter.feedTo((LimitDeterministicAutomaton)automaton, consumer, options);
        }
    }

    public static <S> void feedTo(Automaton<S, ?> automaton, HOAConsumer consumer) {
        HoaPrinter.feedTo(automaton, consumer, EnumSet.noneOf(HoaOption.class));
    }

    public static <S> void feedTo(Automaton<S, ?> automaton, HOAConsumer consumer, EnumSet<HoaOption> options) {
        HoaConsumerExtended<S> hoa = new HoaConsumerExtended<S>(consumer, automaton.factory().alphabet(), (OmegaAcceptance)automaton.acceptance(), automaton.initialStates(), options, automaton.is(Automaton.Property.DETERMINISTIC), automaton.name());
        automaton.accept(hoa.visitor);
        hoa.done();
    }

    public static <S> void feedTo(LimitDeterministicAutomaton<S, ?, ?, ?> ldba, HOAConsumer consumer) {
        HoaPrinter.feedTo(ldba, consumer, EnumSet.noneOf(HoaOption.class));
    }

    public static <S> void feedTo(final LimitDeterministicAutomaton<S, ?, ?, ?> ldba, HOAConsumer consumer, EnumSet<HoaOption> options) {
        Automaton<S, NoneAcceptance> intialComponent = ldba.initialComponent();
        Automaton<?, ?> acceptingComponent = ldba.acceptingComponent();
        final HoaConsumerExtended hoa = new HoaConsumerExtended(consumer, acceptingComponent.factory().alphabet(), (OmegaAcceptance)acceptingComponent.acceptance(), ldba.initialStates(), options, false, "LDBA");
        Automaton.HybridVisitor patchedVisitor = new Automaton.HybridVisitor<S>(){

            @Override
            public void enter(S state) {
                hoa.visitor.enter(state);
            }

            @Override
            public void exit(S state) {
                ldba.epsilonJumps(state).forEach(hoa::addEpsilonEdge);
                ldba.valuationSetJumps(state).forEach((a, b) -> b.forEach(d -> hoa.addEdge((ValuationSet)a, d)));
                hoa.visitor.exit(state);
            }

            @Override
            public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
                hoa.visitor.visitLabelledEdge(TypeUtil.cast(edge), valuationSet);
            }

            @Override
            public void visitEdge(Edge<S> edge, BitSet valuation) {
                hoa.visitor.visitEdge(TypeUtil.cast(edge), valuation);
            }
        };
        intialComponent.accept(patchedVisitor);
        acceptingComponent.accept(hoa.visitor);
        hoa.done();
    }

    public static enum HoaOption {
        ANNOTATIONS,
        SIMPLE_TRANSITION_LABELS;

    }
}

