/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.collections.LabelledTree;
import owl.factories.EquivalenceClassFactory;
import owl.factories.PropositionVisitor;
import owl.factories.jbdd.GcManagedFactory;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.UnaryModalOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.PropositionalIntVisitor;
import owl.ltl.visitors.SubstitutionVisitor;
import owl.ltl.visitors.Visitor;

final class EquivalenceFactory
extends GcManagedFactory<BddEquivalenceClass>
implements EquivalenceClassFactory {
    private static final Visitor<Formula> REMOVE_X = new SubstitutionVisitor(x -> x instanceof XOperator ? ((XOperator)x).operand : x);
    private final List<String> alphabet;
    private final boolean keepRepresentatives;
    private final BddVisitor visitor;
    private final BddEquivalenceClass falseClass;
    private final BddEquivalenceClass trueClass;
    private Formula[] reverseMapping;
    private final Object2IntMap<Formula> mapping;
    private int[] temporalStepSubstitution;
    private int[] unfoldSubstitution;
    private EquivalenceClass[] temporalStepSubstitutes;
    private EquivalenceClass[] unfoldSubstitutes;

    public EquivalenceFactory(Bdd factory, List<String> alphabet, boolean keepRepresentatives) {
        super(factory);
        this.alphabet = List.copyOf(alphabet);
        this.keepRepresentatives = keepRepresentatives;
        int alphabetSize = this.alphabet.size();
        this.mapping = new Object2IntOpenHashMap();
        this.mapping.defaultReturnValue(-1);
        this.reverseMapping = new Formula[alphabetSize];
        this.visitor = new BddVisitor();
        this.unfoldSubstitution = new int[alphabetSize];
        this.unfoldSubstitutes = new EquivalenceClass[alphabetSize];
        this.temporalStepSubstitution = new int[alphabetSize];
        this.temporalStepSubstitutes = new EquivalenceClass[alphabetSize];
        for (int i = 0; i < alphabetSize; ++i) {
            Literal literal = new Literal(i);
            int bdd = factory.createVariable();
            assert (factory.getVariable(bdd) == i);
            this.mapping.put((Object)literal, i);
            this.reverseMapping[i] = literal;
        }
        Arrays.fill(this.unfoldSubstitution, -1);
        this.trueClass = new BddEquivalenceClass(this, factory.getTrueNode(), BooleanConstant.TRUE);
        this.falseClass = new BddEquivalenceClass(this, factory.getFalseNode(), BooleanConstant.FALSE);
    }

    @Override
    public List<String> variables() {
        return this.alphabet;
    }

    @Override
    public EquivalenceClass of(Formula formula) {
        return this.create(formula, this.toBdd(formula));
    }

    @Override
    public EquivalenceClass getFalse() {
        return this.falseClass;
    }

    @Override
    public EquivalenceClass getTrue() {
        return this.trueClass;
    }

    @Override
    public BitSet atomicPropositions(EquivalenceClass clazz) {
        return this.factory.support(this.getBdd(clazz), this.alphabet.size());
    }

    @Override
    public Set<Formula> modalOperators(EquivalenceClass clazz) {
        final BitSet support = this.factory.support(this.getBdd(clazz));
        support.clear(0, this.alphabet.size());
        return new AbstractSet<Formula>(){

            @Override
            public boolean contains(Object o) {
                int i = EquivalenceFactory.this.mapping.getInt(o);
                return i != -1 && support.get(i);
            }

            @Override
            public Stream<Formula> stream() {
                return support.stream().mapToObj(i -> EquivalenceFactory.this.reverseMapping[i]);
            }

            @Override
            public Iterator<Formula> iterator() {
                return this.stream().iterator();
            }

            @Override
            public int size() {
                return support.cardinality();
            }
        };
    }

    @Override
    public boolean implies(EquivalenceClass clazz, EquivalenceClass other) {
        return this.factory.implies(this.getBdd(clazz), this.getBdd(other));
    }

    @Override
    public EquivalenceClass conjunction(Iterator<EquivalenceClass> classes) {
        int resultBdd = this.factory.getTrueNode();
        ArrayList<Formula> representatives = new ArrayList<Formula>();
        while (classes.hasNext()) {
            EquivalenceClass next = classes.next();
            Formula representative = next.representative();
            if (representative == null || representatives == null) {
                representatives = null;
            } else {
                representatives.add(representative);
            }
            resultBdd = this.factory.and(resultBdd, this.getBdd(next));
        }
        return this.create(representatives == null ? null : Conjunction.of(representatives), resultBdd);
    }

    @Override
    public EquivalenceClass disjunction(Iterator<EquivalenceClass> classes) {
        int resultBdd = this.factory.getFalseNode();
        ArrayList<Formula> representatives = new ArrayList<Formula>();
        while (classes.hasNext()) {
            EquivalenceClass next = classes.next();
            Formula representative = next.representative();
            if (representative == null || representatives == null) {
                representatives = null;
            } else {
                representatives.add(representative);
            }
            resultBdd = this.factory.or(resultBdd, this.getBdd(next));
        }
        return this.create(representatives == null ? null : Disjunction.of(representatives), resultBdd);
    }

    @Override
    public EquivalenceClass substitute(EquivalenceClass clazz, Function<Formula, Formula> substitution) {
        BitSet support = this.factory.support(this.getBdd(clazz));
        Function<Formula, Formula> guardedSubstitution = x -> {
            if (x instanceof UnaryModalOperator || x instanceof BinaryModalOperator) {
                return (Formula)substitution.apply((Formula)x);
            }
            return x;
        };
        int[] substitutionMap = new int[this.reverseMapping.length];
        Arrays.setAll(substitutionMap, i -> support.get(i) ? this.toBdd((Formula)guardedSubstitution.apply(this.reverseMapping[i])) : -1);
        return this.transform(clazz, bdd -> this.factory.compose(bdd, substitutionMap), f -> f.accept(new SubstitutionVisitor(guardedSubstitution)));
    }

    @Override
    public EquivalenceClass temporalStep(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.temporalStepBdd(bdd, valuation), f -> f.temporalStep(valuation));
    }

    @Override
    public EquivalenceClass temporalStepUnfold(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.unfold(this.temporalStepBdd(bdd, valuation)), f -> f.temporalStepUnfold(valuation));
    }

    private int temporalStepBdd(int bdd, BitSet valuation) {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            this.temporalStepSubstitution[i] = valuation.get(i) ? this.factory.getTrueNode() : this.factory.getFalseNode();
        }
        return this.factory.compose(bdd, this.temporalStepSubstitution);
    }

    @Override
    public EquivalenceClass unfold(EquivalenceClass clazz) {
        return this.transform(clazz, this::unfold, Formula::unfold);
    }

    @Override
    public EquivalenceClass unfoldTemporalStep(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.temporalStepBdd(this.unfold(bdd), valuation), f -> f.unfoldTemporalStep(valuation));
    }

    private int unfold(int bdd) {
        return this.factory.compose(bdd, this.unfoldSubstitution);
    }

    @Override
    public String toString(EquivalenceClass clazz) {
        int bdd = this.getBdd(clazz);
        if (this.factory.isVariable(bdd)) {
            return PrintVisitor.toString(this.reverseMapping[this.factory.getVariable(bdd)], this.alphabet, false);
        }
        if (this.factory.isVariableNegated(bdd)) {
            return PrintVisitor.toString(this.reverseMapping[this.factory.getVariable(bdd)].not(), this.alphabet, false);
        }
        Formula representative = clazz.representative();
        return representative == null ? String.format("%d", bdd) : PrintVisitor.toString(representative, this.alphabet, false);
    }

    @Override
    public LabelledTree<Integer, EquivalenceClass> temporalStepTree(EquivalenceClass clazz) {
        return this.temporalStepTree(clazz, new HashMap<EquivalenceClass, LabelledTree<Integer, EquivalenceClass>>());
    }

    private LabelledTree<Integer, EquivalenceClass> temporalStepTree(EquivalenceClass clazz, Map<EquivalenceClass, LabelledTree<Integer, EquivalenceClass>> cache) {
        LabelledTree<Integer, EquivalenceClass> tree = cache.get(clazz);
        if (tree != null) {
            return tree;
        }
        int pivot = clazz.atomicPropositions().nextSetBit(0);
        if (pivot == -1) {
            for (int i = 0; i < this.alphabet.size(); ++i) {
                this.temporalStepSubstitution[i] = -1;
            }
            tree = new LabelledTree.Leaf<Integer, BddEquivalenceClass>(this.transform(clazz, x -> this.factory.compose(x, this.temporalStepSubstitution), x -> x.accept(REMOVE_X)));
        } else {
            int[] substitution = new int[pivot + 1];
            Arrays.fill(substitution, 0, pivot, -1);
            substitution[pivot] = this.factory.getTrueNode();
            LabelledTree<Integer, EquivalenceClass> trueSubTree = this.temporalStepTree(this.transform(clazz, x -> this.factory.compose(this.getBdd(clazz), substitution), x -> x.accept(EquivalenceFactory.replaceLiteralBy(pivot, true))), cache);
            substitution[pivot] = this.factory.getFalseNode();
            LabelledTree<Integer, EquivalenceClass> falseSubTree = this.temporalStepTree(this.transform(clazz, x -> this.factory.compose(this.getBdd(clazz), substitution), x -> x.accept(EquivalenceFactory.replaceLiteralBy(pivot, false))), cache);
            tree = new LabelledTree.Node<Integer, EquivalenceClass>(pivot, List.of(trueSubTree, falseSubTree));
        }
        cache.put(clazz, tree);
        return tree;
    }

    private static Visitor<Formula> replaceLiteralBy(int literal, boolean value) {
        return new SubstitutionVisitor(x -> {
            if (!(x instanceof Literal)) {
                return x;
            }
            Literal castedX = (Literal)x;
            return castedX.getAtom() == literal ? BooleanConstant.of(castedX.isNegated() != value) : x;
        });
    }

    private BddEquivalenceClass getClass(EquivalenceClass clazz) {
        assert (this.equals(clazz.factory()));
        return (BddEquivalenceClass)clazz;
    }

    private int getBdd(EquivalenceClass clazz) {
        int bdd = this.getClass((EquivalenceClass)clazz).bdd;
        assert (this.factory.getReferenceCount(bdd) == 1 || this.factory.getReferenceCount(bdd) == -1);
        return bdd;
    }

    private int toBdd(Formula formula) {
        return this.factory.dereference(formula.accept(this.visitor));
    }

    private BddEquivalenceClass create(@Nullable Formula representative, int bdd) {
        if (bdd == this.factory.getTrueNode()) {
            return this.trueClass;
        }
        if (bdd == this.factory.getFalseNode()) {
            return this.falseClass;
        }
        return this.canonicalize(bdd, new BddEquivalenceClass(this, bdd, this.keepRepresentatives ? representative : null));
    }

    private void register(Deque<Formula> propositions) {
        this.checkLiteralAlphabetRange(propositions);
        List newPropositions = propositions.stream().filter(x -> !(x instanceof Literal) && !this.mapping.containsKey(x)).distinct().collect(Collectors.toList());
        int size = this.mapping.size() + newPropositions.size();
        this.reverseMapping = Arrays.copyOf(this.reverseMapping, size);
        this.unfoldSubstitution = Arrays.copyOf(this.unfoldSubstitution, size);
        this.unfoldSubstitutes = Arrays.copyOf(this.unfoldSubstitutes, size);
        this.temporalStepSubstitution = Arrays.copyOf(this.temporalStepSubstitution, size);
        this.temporalStepSubstitutes = Arrays.copyOf(this.temporalStepSubstitutes, size);
        for (Formula proposition : newPropositions) {
            BddEquivalenceClass clazz;
            assert (proposition instanceof UnaryModalOperator || proposition instanceof BinaryModalOperator);
            int variable = this.factory.getVariable(this.factory.createVariable());
            this.mapping.put((Object)proposition, variable);
            this.reverseMapping[variable] = proposition;
            if (proposition instanceof XOperator) {
                Formula operand = ((XOperator)proposition).operand;
                clazz = this.create(operand, this.toBdd(operand));
                this.unfoldSubstitution[variable] = -1;
                this.temporalStepSubstitutes[variable] = clazz;
                this.temporalStepSubstitution[variable] = clazz.bdd;
                continue;
            }
            Formula unfold = proposition.unfold();
            clazz = this.create(unfold, this.toBdd(unfold));
            this.unfoldSubstitutes[variable] = clazz;
            this.unfoldSubstitution[variable] = clazz.bdd;
            this.temporalStepSubstitution[variable] = -1;
        }
    }

    private BddEquivalenceClass transform(EquivalenceClass clazz, IntUnaryOperator bddTransformer, UnaryOperator<Formula> representativeTransformer) {
        BddEquivalenceClass casted = this.getClass(clazz);
        int newBdd = bddTransformer.applyAsInt(casted.bdd);
        Formula representative = clazz.representative();
        Object newRepresentative = casted.bdd == newBdd ? representative : (representative == null ? null : (Formula)representativeTransformer.apply(representative));
        return this.create((Formula)newRepresentative, newBdd);
    }

    private void checkLiteralAlphabetRange(Collection<Formula> formulas) {
        Optional<Formula> literal = formulas.stream().filter(x -> x instanceof Literal && ((Literal)x).getAtom() >= this.alphabet.size()).findAny();
        if (literal.isPresent()) {
            throw new IllegalArgumentException("Literal " + literal.get() + " is not within alphabet.");
        }
    }

    private final class BddVisitor
    extends PropositionalIntVisitor {
        private BddVisitor() {
        }

        @Override
        protected int modalOperatorAction(Formula formula) {
            if (formula instanceof Literal) {
                Literal literal = (Literal)formula;
                EquivalenceFactory.this.checkLiteralAlphabetRange(List.of(literal));
                int bdd = EquivalenceFactory.this.factory.getVariableNode(literal.getAtom());
                return literal.isNegated() ? EquivalenceFactory.this.factory.not(bdd) : bdd;
            }
            assert (formula instanceof UnaryModalOperator || formula instanceof BinaryModalOperator);
            int value = EquivalenceFactory.this.mapping.getInt((Object)formula);
            if (value < 0) {
                EquivalenceFactory.this.register(PropositionVisitor.extractPropositions(formula));
                value = EquivalenceFactory.this.mapping.getInt((Object)formula);
                assert (value >= 0);
            }
            return EquivalenceFactory.this.factory.getVariableNode(value);
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? EquivalenceFactory.this.factory.getTrueNode() : EquivalenceFactory.this.factory.getFalseNode();
        }

        @Override
        public int visit(Conjunction conjunction) {
            int x = EquivalenceFactory.this.factory.getTrueNode();
            for (Formula child : conjunction.children) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.factory.consume(EquivalenceFactory.this.factory.and(x, y), x, y);
            }
            return x;
        }

        @Override
        public int visit(Disjunction disjunction) {
            int x = EquivalenceFactory.this.factory.getFalseNode();
            for (Formula child : disjunction.children) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.factory.consume(EquivalenceFactory.this.factory.or(x, y), x, y);
            }
            return x;
        }
    }

    static final class BddEquivalenceClass
    extends EquivalenceClass {
        final int bdd;

        BddEquivalenceClass(EquivalenceClassFactory factory, int bdd, @Nullable Formula representative) {
            super(factory, representative);
            this.bdd = bdd;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.bdd);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BddEquivalenceClass that = (BddEquivalenceClass)obj;
            assert (this.factory().equals(that.factory()));
            return this.bdd == that.bdd;
        }
    }
}

