/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.factories.jbdd.GcManagedFactory;

final class ValuationFactory
extends GcManagedFactory<BddValuationSet>
implements ValuationSetFactory {
    private static final BooleanExpression<AtomLabel> FALSE = new BooleanExpression(false);
    private static final BooleanExpression<AtomLabel> TRUE = new BooleanExpression(true);
    private static final BitSet EMPTY = new BitSet(0);
    private final List<String> alphabet;
    private final BddValuationSet empty;
    private final BddValuationSet universe;

    ValuationFactory(Bdd factory, List<String> alphabet) {
        super(factory);
        this.alphabet = List.copyOf(alphabet);
        factory.createVariables(this.alphabet.size());
        assert (factory.numberOfVariables() == this.alphabet.size());
        this.universe = this.create(factory.getTrueNode());
        this.empty = this.create(factory.getFalseNode());
    }

    @Override
    public int alphabetSize() {
        return this.alphabet.size();
    }

    @Override
    public List<String> alphabet() {
        return this.alphabet;
    }

    @Override
    public ValuationSet empty() {
        return this.empty;
    }

    @Override
    public ValuationSet of(BitSet valuation, BitSet restrictedAlphabet) {
        return this.create(this.createBdd(valuation, restrictedAlphabet));
    }

    @Override
    public ValuationSet of(BitSet valuation) {
        return this.create(this.createBdd(valuation));
    }

    @Override
    public ValuationSet universe() {
        return this.universe;
    }

    @Override
    public ValuationSet complement(ValuationSet set) {
        return this.create(this.factory.not(this.getBdd(set)));
    }

    @Override
    public BitSet any(ValuationSet set) {
        return this.factory.getSatisfyingAssignment(this.getBdd(set));
    }

    @Override
    public boolean contains(ValuationSet set, BitSet valuation) {
        return this.factory.evaluate(this.getBdd(set), valuation);
    }

    @Override
    public boolean contains(ValuationSet set, ValuationSet other) {
        return this.factory.implies(this.getBdd(set), this.getBdd(other));
    }

    @Override
    public void forEach(ValuationSet set, Consumer<BitSet> action) {
        int variables = this.factory.numberOfVariables();
        this.factory.forEachMinimalSolution(this.getBdd(set), (solution, solutionSupport) -> {
            solutionSupport.flip(0, variables);
            BitSets.powerSet((BitSet)solutionSupport).forEach((? super T nonRelevantValuation) -> {
                nonRelevantValuation.or((BitSet)solution);
                action.accept((BitSet)nonRelevantValuation);
                nonRelevantValuation.and((BitSet)solutionSupport);
            });
            solutionSupport.flip(0, variables);
        });
    }

    @Override
    public void forEach(ValuationSet set, BitSet restriction, Consumer<BitSet> action) {
        int variables = this.factory.numberOfVariables();
        BitSet restrictedVariables = BitSets.copyOf((BitSet)restriction);
        restrictedVariables.flip(0, variables);
        int restrict = this.factory.restrict(this.getBdd(set), restrictedVariables, EMPTY);
        this.factory.forEachMinimalSolution(restrict, (solution, solutionSupport) -> {
            assert (!solution.intersects(restrictedVariables));
            solutionSupport.xor(restriction);
            BitSets.powerSet((BitSet)solutionSupport).forEach((? super T nonRelevantValuation) -> {
                solution.or((BitSet)nonRelevantValuation);
                action.accept((BitSet)solution);
                solution.andNot((BitSet)nonRelevantValuation);
            });
            solutionSupport.xor(restriction);
        });
    }

    @Override
    public boolean intersects(ValuationSet set, ValuationSet other) {
        return !this.factory.implies(this.getBdd(set), this.factory.not(this.getBdd(other)));
    }

    @Override
    public ValuationSet intersection(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.and(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public ValuationSet intersection(Iterator<ValuationSet> sets) {
        int bdd = this.factory.getTrueNode();
        while (sets.hasNext()) {
            bdd = this.factory.and(bdd, this.getBdd(sets.next()));
        }
        return this.create(bdd);
    }

    @Override
    public ValuationSet union(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.or(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public ValuationSet union(Iterator<ValuationSet> sets) {
        int bdd = this.factory.getFalseNode();
        while (sets.hasNext()) {
            bdd = this.factory.or(bdd, this.getBdd(sets.next()));
        }
        return this.create(bdd);
    }

    @Override
    public ValuationSet minus(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.notAnd(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public BooleanExpression<AtomLabel> toExpression(ValuationSet set) {
        return this.toExpression(this.getBdd(set));
    }

    private BooleanExpression<AtomLabel> toExpression(int bdd) {
        if (bdd == this.factory.getFalseNode()) {
            return FALSE;
        }
        if (bdd == this.factory.getTrueNode()) {
            return TRUE;
        }
        BooleanExpression letter = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)this.factory.getVariable(bdd)));
        BooleanExpression pos = this.toExpression(this.factory.getHigh(bdd));
        BooleanExpression neg = this.toExpression(this.factory.getLow(bdd));
        if (pos.isTRUE()) {
            pos = letter;
        } else if (!pos.isFALSE()) {
            pos = letter.and(pos);
        }
        if (neg.isTRUE()) {
            neg = letter.not();
        } else if (!neg.isFALSE()) {
            neg = letter.not().and(neg);
        }
        if (pos.isFALSE()) {
            return neg;
        }
        if (neg.isFALSE()) {
            return pos;
        }
        return pos.or(neg);
    }

    private BddValuationSet create(int bdd) {
        return this.canonicalize(bdd, new BddValuationSet(this, bdd));
    }

    private int createBdd(BitSet set, BitSet base) {
        assert (base.length() <= this.alphabet.size());
        int bdd = this.factory.getTrueNode();
        int i = base.nextSetBit(0);
        while (i != -1) {
            bdd = this.createBddUpdateHelper(set, i, bdd);
            i = base.nextSetBit(i + 1);
        }
        return bdd;
    }

    private int createBdd(BitSet set) {
        int bdd = this.factory.getTrueNode();
        for (int i = 0; i < this.alphabet.size(); ++i) {
            bdd = this.createBddUpdateHelper(set, i, bdd);
        }
        return bdd;
    }

    private int createBddUpdateHelper(BitSet set, int var, int bdd) {
        int variableNode = this.factory.getVariableNode(var);
        assert (this.factory.isVariable(variableNode));
        return this.factory.and(bdd, set.get(var) ? variableNode : this.factory.not(variableNode));
    }

    private int getBdd(ValuationSet vs) {
        assert (this.equals(vs.getFactory()));
        int bdd = ((BddValuationSet)vs).bdd;
        assert (this.factory.getReferenceCount(bdd) > 0 || this.factory.getReferenceCount(bdd) == -1);
        return bdd;
    }

    static final class BddValuationSet
    extends ValuationSet {
        final int bdd;

        BddValuationSet(ValuationFactory factory, int bdd) {
            super(factory);
            this.bdd = bdd;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.bdd);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            BddValuationSet other = (BddValuationSet)o;
            assert (this.getFactory().equals(other.getFactory()));
            return this.bdd == other.bdd;
        }
    }
}

