/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.LabelledEdgesAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.LabelledEdge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.game.Game;
import owl.game.ValueEdgeTuple;
import owl.util.annotation.Tuple;

public final class GameFactory {
    private GameFactory() {
    }

    public static <S, A extends OmegaAcceptance> Game<S, A> copyOf(Game<S, A> game) {
        assert (game.is(Automaton.Property.COMPLETE)) : "Only defined for complete game.";
        return new ImmutableGame<S, A>(game);
    }

    static final class ImmutableGame<S, A extends OmegaAcceptance>
    implements Game<S, A>,
    LabelledEdgesAutomatonMixin<S, A> {
        private final A acceptance;
        private final ValuationSetFactory factory;
        private final ImmutableValueGraph<S, ValueEdge> graph;
        private final Set<S> initialStates;
        private final Set<S> player1Nodes;
        private final List<String> variablesPlayer1;
        private final List<String> variablesPlayer2;
        private final BiFunction<S, Game.Owner, BitSet> choice;

        ImmutableGame(Game<S, A> game) {
            HashSet player1NodesBuilder = new HashSet();
            MutableValueGraph graph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
            for (Object state : game.states()) {
                if (Game.Owner.PLAYER_1 == game.getOwner(state)) {
                    player1NodesBuilder.add(state);
                }
                game.forEachLabelledEdge(state, (edge, valuations) -> {
                    ValueEdge cfr_ignored_0 = (ValueEdge)graph.putEdgeValue(state, edge.successor(), (Object)ValueEdgeTuple.create(edge.smallestAcceptanceSet(), valuations));
                });
            }
            this.acceptance = game.acceptance();
            this.factory = game.factory();
            this.graph = ImmutableValueGraph.copyOf((ValueGraph)graph);
            this.initialStates = Set.copyOf(game.initialStates());
            this.player1Nodes = Set.copyOf(player1NodesBuilder);
            this.variablesPlayer1 = List.copyOf(game.getVariables(Game.Owner.PLAYER_1));
            this.variablesPlayer2 = List.copyOf(game.getVariables(Game.Owner.PLAYER_2));
            this.choice = game::getChoice;
        }

        @Override
        public BitSet getChoice(S state, Game.Owner owner) {
            return this.choice.apply(state, owner);
        }

        @Override
        public A acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.factory;
        }

        @Override
        public Set<S> initialStates() {
            return this.initialStates;
        }

        @Override
        public Collection<LabelledEdge<S>> labelledEdges(S state) {
            return this.graph.edges().stream().filter(x -> x.source().equals(state)).map(x -> {
                ValueEdge valueEdge = (ValueEdge)this.graph.edgeValue(x.source(), x.target()).get();
                if (valueEdge.colour() == -1) {
                    return LabelledEdge.of(x.target(), valueEdge.valuationSet());
                }
                return LabelledEdge.of(x.target(), valueEdge.colour(), valueEdge.valuationSet());
            }).collect(Collectors.toSet());
        }

        @Override
        public Game.Owner getOwner(S state) {
            return this.player1Nodes.contains(state) ? Game.Owner.PLAYER_1 : Game.Owner.PLAYER_2;
        }

        @Override
        public Set<S> predecessors(S state) {
            return this.graph.predecessors(state);
        }

        @Override
        public Set<S> states() {
            return this.graph.nodes();
        }

        @Override
        public Set<S> successors(S state) {
            return this.graph.successors(state);
        }

        @Override
        public List<String> getVariables(Game.Owner owner) {
            return owner == Game.Owner.PLAYER_1 ? this.variablesPlayer1 : this.variablesPlayer2;
        }

        @Value.Immutable
        @Tuple
        static abstract class ValueEdge {
            ValueEdge() {
            }

            abstract int colour();

            abstract ValuationSet valuationSet();
        }
    }
}

