/*
 * Decompiled with CFR 0.152.
 */
package owl.jni;

import com.google.common.base.Preconditions;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;

public final class JniAutomaton<S> {
    private static final int ACCEPTING_COLOUR = -2;
    private static final int ACCEPTING_STATE = -2;
    private static final int REJECTING_COLOUR = -1;
    private static final int REJECTING_STATE = -1;
    private static final int UNKNOWN_STATE = Integer.MIN_VALUE;
    private final Acceptance acceptance;
    private final Predicate<S> acceptingSink;
    private final Automaton<S, ?> automaton;
    private final List<S> int2StateMap;
    private final Object2IntMap<S> state2intMap;
    @Nullable
    private SoftReference<int[]> edgesCache;
    @Nullable
    private SoftReference<int[]> successorsCache;

    JniAutomaton(Automaton<S, ?> automaton, Predicate<S> acceptingSink) {
        this(automaton, acceptingSink, JniAutomaton.detectAcceptance(automaton));
    }

    JniAutomaton(Automaton<S, ?> automaton, Predicate<S> acceptingSink, Acceptance acceptance) {
        Preconditions.checkArgument((automaton.initialStates().size() == 1 ? 1 : 0) != 0);
        this.automaton = automaton;
        this.acceptance = acceptance;
        this.acceptingSink = acceptingSink;
        this.int2StateMap = new ArrayList<S>();
        this.int2StateMap.add(this.automaton.onlyInitialState());
        this.state2intMap = new Object2IntOpenHashMap();
        this.state2intMap.put(this.automaton.onlyInitialState(), 0);
        this.state2intMap.defaultReturnValue(Integer.MIN_VALUE);
    }

    private static Acceptance detectAcceptance(Automaton<?, ?> automaton) {
        Object acceptance = automaton.acceptance();
        if (acceptance instanceof AllAcceptance) {
            return Acceptance.SAFETY;
        }
        if (acceptance instanceof BuchiAcceptance) {
            return Acceptance.BUCHI;
        }
        if (acceptance instanceof CoBuchiAcceptance) {
            return Acceptance.CO_BUCHI;
        }
        if (acceptance instanceof ParityAcceptance) {
            switch (((ParityAcceptance)acceptance).parity()) {
                case MAX_EVEN: {
                    return Acceptance.PARITY_MAX_EVEN;
                }
                case MAX_ODD: {
                    return Acceptance.PARITY_MAX_ODD;
                }
                case MIN_ODD: {
                    return Acceptance.PARITY_MIN_ODD;
                }
                case MIN_EVEN: {
                    return Acceptance.PARITY_MIN_EVEN;
                }
            }
            throw new AssertionError((Object)"Unreachable Code.");
        }
        throw new AssertionError((Object)"Unreachable Code.");
    }

    public int acceptance() {
        return this.acceptance.ordinal();
    }

    public int acceptanceSetCount() {
        return ((OmegaAcceptance)this.automaton.acceptance()).acceptanceSets();
    }

    private int[] edgeBuffer() {
        int[] buffer;
        int[] nArray = buffer = this.edgesCache == null ? null : this.edgesCache.get();
        if (buffer != null) {
            return buffer;
        }
        int[] newBuffer = new int[2 << this.automaton.factory().alphabetSize()];
        this.edgesCache = new SoftReference<int[]>(newBuffer);
        return newBuffer;
    }

    private int[] successorBuffer() {
        int[] buffer;
        int[] nArray = buffer = this.successorsCache == null ? null : this.successorsCache.get();
        if (buffer != null) {
            return buffer;
        }
        int[] newBuffer = new int[1 << this.automaton.factory().alphabetSize()];
        this.successorsCache = new SoftReference<int[]>(newBuffer);
        return newBuffer;
    }

    public int[] edges(int stateIndex) {
        S state = this.int2StateMap.get(stateIndex);
        int i = 0;
        int[] edges = this.edgeBuffer();
        List labelledEdges = this.automaton.prefersLabelled() ? List.copyOf(this.automaton.labelledEdges(state)) : null;
        for (BitSet valuation : BitSets.powerSet((int)this.automaton.factory().alphabetSize())) {
            Edge<Object> edge = labelledEdges == null ? this.automaton.edge(state, valuation) : JniAutomaton.lookup(labelledEdges, valuation);
            if (edge == null) {
                edges[i] = -1;
                edges[i + 1] = -1;
            } else if (this.acceptingSink.test(edge.successor())) {
                edges[i] = -2;
                edges[i + 1] = -2;
            } else {
                edges[i] = this.lookup(edge.successor());
                edges[i + 1] = edge.largestAcceptanceSet();
            }
            i += 2;
        }
        return edges;
    }

    public int[] successors(int stateIndex) {
        S state = this.int2StateMap.get(stateIndex);
        int i = 0;
        int[] successors = this.successorBuffer();
        List labelledEdges = this.automaton.prefersLabelled() ? List.copyOf(this.automaton.labelledEdges(state)) : null;
        for (BitSet valuation : BitSets.powerSet((int)this.automaton.factory().alphabetSize())) {
            S successor;
            if (labelledEdges == null) {
                successor = this.automaton.successor(state, valuation);
            } else {
                Edge edge = JniAutomaton.lookup(labelledEdges, valuation);
                successor = edge == null ? null : edge.successor();
                Object v0 = successor;
            }
            successors[i] = successor == null ? -1 : (this.acceptingSink.test(successor) ? -2 : this.lookup(successor));
            ++i;
        }
        return successors;
    }

    int size() {
        return this.automaton.size();
    }

    private int lookup(S o) {
        int index = this.state2intMap.getInt(o);
        if (index == Integer.MIN_VALUE) {
            this.int2StateMap.add(o);
            this.state2intMap.put(o, this.int2StateMap.size() - 1);
            index = this.int2StateMap.size() - 1;
        }
        return index;
    }

    @Nullable
    private static <T> Edge<T> lookup(List<LabelledEdge<T>> labelledEdges, BitSet valuation) {
        int size = labelledEdges.size();
        for (int i = 0; i < size; ++i) {
            LabelledEdge<T> labelledEdge = labelledEdges.get(i);
            if (!labelledEdge.valuations.contains(valuation)) continue;
            return labelledEdge.edge;
        }
        return null;
    }

    static enum Acceptance {
        BUCHI,
        CO_BUCHI,
        CO_SAFETY,
        PARITY,
        PARITY_MAX_EVEN,
        PARITY_MAX_ODD,
        PARITY_MIN_EVEN,
        PARITY_MIN_ODD,
        SAFETY,
        WEAK,
        BOTTOM;


        Acceptance lub(Acceptance other) {
            if (this == BOTTOM || this == other) {
                return other;
            }
            switch (this) {
                case CO_SAFETY: {
                    return other == SAFETY ? WEAK : other;
                }
                case SAFETY: {
                    return other == CO_SAFETY ? WEAK : other;
                }
                case WEAK: {
                    return other == SAFETY || other == CO_SAFETY ? this : other;
                }
                case BUCHI: {
                    return other == CO_SAFETY || other == SAFETY || other == WEAK ? this : PARITY;
                }
                case CO_BUCHI: {
                    return other == CO_SAFETY || other == SAFETY || other == WEAK ? this : PARITY;
                }
            }
            return PARITY;
        }

        boolean isLessThanParity() {
            return this == BUCHI || this == CO_BUCHI || this == CO_SAFETY || this == SAFETY || this == WEAK || this == BOTTOM;
        }

        boolean isLessOrEqualWeak() {
            return this == CO_SAFETY || this == SAFETY || this == WEAK || this == BOTTOM;
        }
    }
}

