/*
 * Decompiled with CFR 0.152.
 */
package owl.jni;

import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.collections.LabelledTree;
import owl.jni.FormulaPartition;
import owl.jni.Hacks;
import owl.jni.JniAutomaton;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.PropositionalFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.rewriter.LiteralMapper;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.rewriter.SimplifierFactory;
import owl.ltl.util.FormulaIsomorphism;
import owl.ltl.visitors.PropositionalVisitor;
import owl.ltl.visitors.SubstitutionVisitor;
import owl.run.DefaultEnvironment;
import owl.translations.LTL2DAFunction;

public class JniEmersonLeiAutomaton {
    public final LabelledTree<Tag, Reference> structure;
    public final List<JniAutomaton<?>> automata;

    private JniEmersonLeiAutomaton(LabelledTree<Tag, Reference> structure, List<JniAutomaton<?>> automata) {
        this.structure = structure;
        this.automata = automata;
    }

    public static JniEmersonLeiAutomaton of(Formula formula, boolean simplify, boolean monolithic, SafetySplittingMode mode, boolean onTheFly) {
        Formula nnfLight = formula.accept(new SubstitutionVisitor(Formula::nnf));
        Formula processedFormula = simplify ? SimplifierFactory.apply(nnfLight, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT) : nnfLight;
        Builder builder = new Builder(mode, onTheFly, processedFormula.accept(AcceptanceAnnotator.INSTANCE));
        LabelledTree<Tag, Reference> structure = monolithic ? builder.modalOperatorAction(processedFormula) : processedFormula.accept(builder);
        return new JniEmersonLeiAutomaton(structure, List.copyOf(builder.automata));
    }

    public static JniEmersonLeiAutomaton of(Formula formula, boolean simplify, boolean monolithic, int mode, boolean onTheFly) {
        return JniEmersonLeiAutomaton.of(formula, simplify, monolithic, SafetySplittingMode.values()[mode], onTheFly);
    }

    private static class AcceptanceAnnotator
    extends PropositionalVisitor<Map<Formula, JniAutomaton.Acceptance>> {
        static final AcceptanceAnnotator INSTANCE = new AcceptanceAnnotator();

        private AcceptanceAnnotator() {
        }

        @Override
        protected Map<Formula, JniAutomaton.Acceptance> modalOperatorAction(Formula formula) {
            if (SyntacticFragment.SAFETY.contains(formula)) {
                return Map.of(formula, JniAutomaton.Acceptance.SAFETY);
            }
            if (SyntacticFragment.CO_SAFETY.contains(formula)) {
                return Map.of(formula, JniAutomaton.Acceptance.CO_SAFETY);
            }
            if (SyntacticFragments.isDetBuchiRecognisable(formula)) {
                return Map.of(formula, JniAutomaton.Acceptance.BUCHI);
            }
            if (SyntacticFragments.isDetCoBuchiRecognisable(formula)) {
                return Map.of(formula, JniAutomaton.Acceptance.CO_BUCHI);
            }
            return Map.of(formula, JniAutomaton.Acceptance.PARITY);
        }

        @Override
        public Map<Formula, JniAutomaton.Acceptance> visit(Biconditional biconditional) {
            HashMap<Formula, JniAutomaton.Acceptance> acceptanceMap = new HashMap<Formula, JniAutomaton.Acceptance>();
            acceptanceMap.putAll(biconditional.left.accept(this));
            acceptanceMap.putAll(biconditional.right.accept(this));
            JniAutomaton.Acceptance leftAcceptance = (JniAutomaton.Acceptance)((Object)acceptanceMap.get(biconditional.left));
            JniAutomaton.Acceptance rightAcceptance = (JniAutomaton.Acceptance)((Object)acceptanceMap.get(biconditional.right));
            if (leftAcceptance.lub(rightAcceptance).isLessOrEqualWeak()) {
                acceptanceMap.put(biconditional, JniAutomaton.Acceptance.WEAK);
            } else {
                acceptanceMap.put(biconditional, JniAutomaton.Acceptance.PARITY);
            }
            return acceptanceMap;
        }

        @Override
        public Map<Formula, JniAutomaton.Acceptance> visit(BooleanConstant booleanConstant) {
            return Map.of(booleanConstant, JniAutomaton.Acceptance.BOTTOM);
        }

        @Override
        public Map<Formula, JniAutomaton.Acceptance> visit(Conjunction conjunction) {
            return this.visitPropositional(conjunction);
        }

        @Override
        public Map<Formula, JniAutomaton.Acceptance> visit(Disjunction disjunction) {
            return this.visitPropositional(disjunction);
        }

        private Map<Formula, JniAutomaton.Acceptance> visitPropositional(PropositionalFormula propositionalFormula) {
            JniAutomaton.Acceptance acceptance = JniAutomaton.Acceptance.BOTTOM;
            HashMap<Formula, JniAutomaton.Acceptance> acceptanceMap = new HashMap<Formula, JniAutomaton.Acceptance>();
            for (Formula child : propositionalFormula.children) {
                Map<Formula, JniAutomaton.Acceptance> childDecisions = child.accept(this);
                acceptanceMap.putAll(childDecisions);
                acceptance = acceptance.lub((JniAutomaton.Acceptance)((Object)acceptanceMap.get(child)));
            }
            acceptanceMap.put(propositionalFormula, acceptance);
            return acceptanceMap;
        }
    }

    static final class Builder
    extends PropositionalVisitor<LabelledTree<Tag, Reference>> {
        private final SafetySplittingMode safetySplittingMode;
        private final List<JniAutomaton<?>> automata = new ArrayList();
        private final Map<Formula, Reference> lookup = new HashMap<Formula, Reference>();
        private final Map<Formula, JniAutomaton.Acceptance> annotatedTree;
        private final LTL2DAFunction translator;

        public Builder(SafetySplittingMode safetySplittingMode, boolean onTheFly, Map<Formula, JniAutomaton.Acceptance> annotatedTree) {
            this.safetySplittingMode = safetySplittingMode;
            this.annotatedTree = new HashMap<Formula, JniAutomaton.Acceptance>(annotatedTree);
            this.translator = new LTL2DAFunction(DefaultEnvironment.standard(), onTheFly, EnumSet.of(LTL2DAFunction.Constructions.SAFETY, LTL2DAFunction.Constructions.CO_SAFETY, LTL2DAFunction.Constructions.BUCHI, LTL2DAFunction.Constructions.CO_BUCHI, LTL2DAFunction.Constructions.PARITY));
        }

        private LabelledTree<Tag, Reference> createLeaf(Formula formula) {
            assert (SyntacticFragment.NNF.contains(formula));
            Reference reference = this.lookup.get(formula);
            if (reference != null) {
                return new LabelledTree.Leaf<Tag, Reference>(reference);
            }
            for (Map.Entry<Formula, Reference> entry : this.lookup.entrySet()) {
                int[] mapping = FormulaIsomorphism.compute(formula, entry.getKey());
                if (mapping == null) continue;
                reference = entry.getValue();
                int[] newMapping = Arrays.copyOf(mapping, mapping.length);
                for (int i = 0; i < newMapping.length; ++i) {
                    int j = newMapping[i];
                    if (j == -1) continue;
                    newMapping[i] = reference.alphabetMapping.get(j);
                    assert (newMapping[i] != -1);
                }
                return new LabelledTree.Leaf<Tag, Reference>(new Reference(formula, reference.index, newMapping));
            }
            LiteralMapper.ShiftedFormula shiftedFormula = LiteralMapper.shiftLiterals(formula);
            LabelledFormula labelledFormula = Hacks.attachDummyAlphabet(shiftedFormula.formula);
            Automaton<?, ?> automaton = this.translator.apply(labelledFormula);
            JniAutomaton<Object> jniAutomaton = SyntacticFragment.SAFETY.contains(shiftedFormula.formula) ? new JniAutomaton<EquivalenceClass>(AutomatonUtil.cast(automaton, EquivalenceClass.class, AllAcceptance.class), EquivalenceClass::isTrue) : (SyntacticFragment.CO_SAFETY.contains(shiftedFormula.formula) ? new JniAutomaton<EquivalenceClass>(AutomatonUtil.cast(automaton, EquivalenceClass.class, BuchiAcceptance.class), EquivalenceClass::isTrue, JniAutomaton.Acceptance.CO_SAFETY) : new JniAutomaton<Object>(automaton, x -> false));
            Reference newReference = new Reference(formula, this.automata.size(), shiftedFormula.mapping);
            this.automata.add(jniAutomaton);
            this.lookup.put(formula, newReference);
            return new LabelledTree.Leaf<Tag, Reference>(newReference);
        }

        private List<LabelledTree<Tag, Reference>> createLeaves(FormulaPartition partition, Function<Iterable<Formula>, Formula> merger) {
            ArrayList<LabelledTree<Tag, Reference>> children = new ArrayList<LabelledTree<Tag, Reference>>();
            Set<Formula> safety = partition.safety();
            Set<Formula> coSafety = partition.cosafety();
            switch (this.safetySplittingMode) {
                case NEVER: {
                    if (!safety.isEmpty()) {
                        children.add(this.createLeaf(merger.apply(safety)));
                    }
                    if (coSafety.isEmpty()) break;
                    children.add(this.createLeaf(merger.apply(coSafety)));
                    break;
                }
                case AUTO: {
                    partition.singleStepSafetyClusters.values().forEach(x -> x.clusterList.forEach(y -> children.add(this.createLeaf((Formula)merger.apply((Iterable<Formula>)y)))));
                    partition.safetyClusters.clusterList.forEach(x -> children.add(this.createLeaf((Formula)merger.apply((Iterable<Formula>)x))));
                    partition.cosafetyClusters.clusterList.forEach(x -> children.add(this.createLeaf((Formula)merger.apply((Iterable<Formula>)x))));
                    break;
                }
                case ALWAYS: {
                    safety.forEach(x -> children.add(this.createLeaf((Formula)x)));
                    coSafety.forEach(x -> children.add(this.createLeaf((Formula)x)));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unreachable Code!");
                }
            }
            partition.dba.forEach(x -> children.add(this.createLeaf((Formula)x)));
            partition.dca.forEach(x -> children.add(this.createLeaf((Formula)x)));
            ArrayList lessThanParityRequired = new ArrayList();
            ArrayList parityRequired = new ArrayList();
            partition.dpa.forEach(x -> {
                if (this.annotatedTree.get(x) == JniAutomaton.Acceptance.PARITY) {
                    parityRequired.add(x);
                } else {
                    assert (this.annotatedTree.get(x).isLessThanParity());
                    lessThanParityRequired.add(x);
                }
            });
            for (Formula child : lessThanParityRequired) {
                children.add(child.accept(this));
            }
            if (parityRequired.size() == 1) {
                children.add(((Formula)parityRequired.get(0)).accept(this));
            } else if (parityRequired.size() > 1) {
                Formula cnfNormalForm;
                Formula dnfNormalForm;
                Formula mergedFormula = merger.apply(parityRequired).nnf();
                if (mergedFormula instanceof Disjunction && !mergedFormula.equals(dnfNormalForm = NormalForms.toDnfFormula(mergedFormula))) {
                    this.annotatedTree.putAll(dnfNormalForm.accept(AcceptanceAnnotator.INSTANCE));
                    children.add(dnfNormalForm.accept(this));
                    return children;
                }
                if (mergedFormula instanceof Conjunction && !mergedFormula.equals(cnfNormalForm = NormalForms.toCnfFormula(mergedFormula))) {
                    this.annotatedTree.putAll(cnfNormalForm.accept(AcceptanceAnnotator.INSTANCE));
                    children.add(cnfNormalForm.accept(this));
                    return children;
                }
                children.add(this.createLeaf(mergedFormula));
            }
            return children;
        }

        @Override
        protected LabelledTree<Tag, Reference> modalOperatorAction(Formula formula) {
            return this.createLeaf(formula);
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Biconditional biconditional) {
            if (this.annotatedTree.get(biconditional.left) == JniAutomaton.Acceptance.PARITY && this.annotatedTree.get(biconditional.right) == JniAutomaton.Acceptance.PARITY) {
                Formula nnf = biconditional.nnf();
                this.annotatedTree.putAll(nnf.accept(AcceptanceAnnotator.INSTANCE));
                return nnf.accept(this);
            }
            return new LabelledTree.Node<Tag, Reference>(Tag.BICONDITIONAL, List.of(biconditional.left.accept(this), biconditional.right.accept(this)));
        }

        @Override
        public LabelledTree<Tag, Reference> visit(BooleanConstant booleanConstant) {
            return this.createLeaf(booleanConstant);
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Conjunction conjunction) {
            FormulaPartition partition = FormulaPartition.of(conjunction.children);
            List leaves = this.createLeaves(partition, Conjunction::of);
            return leaves.size() == 1 ? leaves.get(0) : new LabelledTree.Node(Tag.CONJUNCTION, leaves);
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Disjunction disjunction) {
            FormulaPartition partition = FormulaPartition.of(disjunction.children);
            List leaves = this.createLeaves(partition, Disjunction::of);
            return leaves.size() == 1 ? leaves.get(0) : new LabelledTree.Node(Tag.DISJUNCTION, leaves);
        }
    }

    public static final class Reference {
        public final Formula formula;
        public final int index;
        public final ImmutableIntArray alphabetMapping;

        Reference(Formula formula, int index, ImmutableIntArray alphabetMapping) {
            this.formula = formula;
            this.index = index;
            this.alphabetMapping = alphabetMapping;
        }

        Reference(Formula formula, int index, int[] alphabetMapping) {
            this(formula, index, ImmutableIntArray.copyOf((int[])alphabetMapping));
        }

        public int[] alphabetMapping() {
            return this.alphabetMapping.toArray();
        }
    }

    public static enum SafetySplittingMode {
        NEVER,
        AUTO,
        ALWAYS;

    }

    static enum Tag {
        BICONDITIONAL,
        CONJUNCTION,
        DISJUNCTION;

    }
}

